"""Unit tests for the buildscripts.resmokelib.hang_analyzer.dumper package"""

import platform
import unittest
from unittest.mock import MagicMock, Mock, patch

from buildscripts.resmokelib.hang_analyzer.dumper import GDBDumper


@unittest.skipUnless(platform.system() == "Linux", "GDBDumper is only for linux.")
class TestBinaryParsing(unittest.TestCase):
    def setUp(self):
        self.logger = Mock()
        self.dumper = GDBDumper(self.logger, "stdout")

    def _get_binary_from_core_dump(self, gdb_output):
        with patch("buildscripts.resmokelib.hang_analyzer.dumper.subprocess.run") as run:
            run.return_value = MagicMock(stdout=gdb_output)
            return self.dumper.get_binary_from_core_dump("core")

    def test_no_version(self):
        gdb_output = """
                     Core was generated by `/data/mci/56724897cdbfea2f5acb1cdd0b2556a6/src/dist-test/bin/mongod --someArg'. 
                     """
        name, version = self._get_binary_from_core_dump(gdb_output)
        self.assertEqual(name, "mongod")
        self.assertEqual(version, None)

    def test_binary_version(self):
        gdb_output = """
                     Core was generated by `/data/mci/56724897cdbfea2f5acb1cdd0b2556a6/src/dist-test/bin/mongod-8.0'. 
                     """
        name, version = self._get_binary_from_core_dump(gdb_output)
        self.assertEqual(name, "mongod-8.0")
        self.assertEqual(version, "8.0")

    def test_multiline(self):
        gdb_output = """
                     Core was generated by `/data/mci/56724897cdbfea2f5acb1cdd0b2556a6/src/dist-test/bin/mongo 
                     jstests/core/query/query_settings/query_settings_index_application_distinct.js'.
                     """
        name, version = self._get_binary_from_core_dump(gdb_output)
        self.assertEqual(name, "mongo")
        self.assertEqual(version, None)


if __name__ == "__main__":
    unittest.main()
