# Code Owners

## ALLOWED_UNOWNED_FILES.yml File Format

This file is for repos that require all files be owned. Some files may be listed here as an exception and will be added to the end of the CODEOWNERS.

`version` is the current version of the `ALLOWED_UNOWNED_FILES.yml` file format. The only version is `1.0.0`.

`filters` are a list of filters that each have a `filter` and `justificaiton` field.

`filter` is a file path. This file path must start with a `/` and is relative to the root repo directory. Directories or globs are not supported at the moment to ensure careful selection of files allowed to be unowned. This can be reconsidered if proper usecases appear.

`justification` is the reason why this file should be unowned. A common case is that this is a generated file that has checks in CI to ensure it is in the correct format.

### Example file

```yaml
version: 1.0.0 # The version of the file you are using.
filters: # List of all filters
  - filter: "/.github/CODEOWNERS" # path to the file, this must be a file and not a directory or glob.
    justification: "Generated by all of the individual owners files in the repo." # Reason this file should be unowned.
```

### Configuration

This can be configured in any repo with `bazel_rules_mongo` by putting the following lines in your `.bazelrc` file:

```
common --define codeowners_have_allowed_unowned_files=True
common --define codeowners_allowed_unowned_files_path=.github/ALLOWED_UNOWNED_FILES.yml
```
