#!/usr/bin/env python3
"""
Check to make sure poetry.lock is synced with pyproject.toml.

Returns nonzero if poetry.lock and pyproject.toml are not synced
"""

import subprocess

POETRY_LOCK_V200 = (
    """# This file is automatically @generated by Poetry 2.0.0 and should not be changed by hand."""
)

# This has a great error message as part of the failure case
subprocess.run(["poetry", "check", "--lock"], check=True)

# Check if the poetry lock file was generated with poetry 2.0.0
with open("poetry.lock", "r") as poetry_lock:
    if POETRY_LOCK_V200 not in poetry_lock.read(len(POETRY_LOCK_V200)):
        raise Exception("""Poetry lockfile was not generated by poetry 2.0.0.
    Make sure to have poetry 2.0.0 installed when running poetry lock.
    If you are seeing this message please follow the poetry install steps in docs/building.md.""")
