/**
 * $group stages with no accumulators or with only $first or only $last accumulators can sometimes
 * be converted into a DISTINCT_SCAN (see SERVER-9507 and SERVER-37304). This optimization
 * potentially applies to a $group when it begins the pipeline or when it is preceded only by one or
 * both of $match and $sort (in that order). In all cases, it must be possible to do a DISTINCT_SCAN
 * that sees each value of the distinct field exactly once among matching documents and also
 * provides any requested sort. The test queries below show most $match/$sort/$group combinations
 * where that is possible.
 *
 * @tags: [
 *   # The sharding and $facet passthrough suites modifiy aggregation pipelines in a way that
 *   # prevents the DISTINCT_SCAN optimization from being applied, which breaks the test.
 *   assumes_unsharded_collection,
 *   do_not_wrap_aggregations_in_facets,
 *   # Index filter commands do not support causal consistency.
 *   does_not_support_causal_consistency,
 *   requires_fcv_63,
 *   not_allowed_with_signed_security_token,
 * ]
 */

import {
    runGroupConversionToDistinctScanTests
} from "jstests/libs/query/group_conversion_to_distinct_scan.js";
import {prepareCollection} from "jstests/libs/query/group_to_distinct_scan_utils.js";

prepareCollection(db);
// Query hashes programmatically obtained for the subsequent tests.
// TODO SERVER-100039: replace this with passthrough suite for validating query hashes.
const queryHashes = [
    "713C6038B170FE5910FD2B23E83E1317A58F6D4F032E3F7C1405803F7A961BA7",
    "DA8F604076C771F0B4D4A2AE0D0C9507F1A623699F9B6B91A6B3DE32E64D735F",
    "DA8F604076C771F0B4D4A2AE0D0C9507F1A623699F9B6B91A6B3DE32E64D735F",
    "DA8F604076C771F0B4D4A2AE0D0C9507F1A623699F9B6B91A6B3DE32E64D735F",
    "DA8F604076C771F0B4D4A2AE0D0C9507F1A623699F9B6B91A6B3DE32E64D735F",
    "DA8F604076C771F0B4D4A2AE0D0C9507F1A623699F9B6B91A6B3DE32E64D735F",
    "DA8F604076C771F0B4D4A2AE0D0C9507F1A623699F9B6B91A6B3DE32E64D735F",
    "DA8F604076C771F0B4D4A2AE0D0C9507F1A623699F9B6B91A6B3DE32E64D735F",
    "DA8F604076C771F0B4D4A2AE0D0C9507F1A623699F9B6B91A6B3DE32E64D735F",
    "B23BE224E5EA53AB8A7094CFBA9DB69939CC603FF77D805C61CE385593E2FDF7",
    "CEBCB223021494FA14A745198363147173155023275C9FD56689CAC7AB318160",
    "ABE59B1F05B8176DC3DF4B11DC793E5DD7DC4D5DA7E087E71423D10FDDC90519",
    "5DBDB589A18A8CBDD2D069B3D48B2C83FB33C697591D24058C7B517ED0B3D28A",
    "E29B13271AE87341D21C3129FC0284EAA325353CFD6991B68554093304F023B0",
    "891D59B4B66E5DCBCF8F030D3E53436E6D3324E1270B8C04D9805DBE9CEA80B7",
    "D3755A31BA6F13A88011516B8B4921BF483F8D7AA848FE0F3CAD3037A1B19010",
    "013CA310B8005ACA6D41EA33E3C7F67EC7B9A01A5ECEF8E326D4004D48813D40",
    "23F0E380DBEF8082468101BCA860FE1259F792A96472B3E8AA6B5660412A6136",
    "46812A1AD7FDB29AA71A606BF86C5D63E420BC8F08A2B146207413CFC056D032",
    "E6DF4C813A7F8B9CE9549962638C52EF9281C32A309EF0853E7401F46CD7FBBB",
    "53EC7D6C3CD2DE2B8BD0B334690DF03B5D050D77F22676E4861E76E9FA103844",
    "41A142B3E73E8C8634C6D0B4A8174DAA333743550B2FC5AE21D913C4EB4F9E77",
    "5DE309F14F5F3D9385C04C0B8B6DE87FA5968732FD1E84CF25B112B8A0C0D8B0",
    "6E013494DBAE51A22B01CA38DCE011D331FD9403EFC66888CA9CCB01FC358B6F",
    "EE735F3F3C059A6823830877AF9BD7F1FED81F8A2515CB202ACFC10548028A9D",
    "1B5D49DDB9D4E482EAC1690884FE3E869BE80DA4102F4375AB6141D469BABFA6",
    "8AA2F6506FECCD30222F4F697DCE37B5EE88B5B1B19CB0B50E45AE51F26E1FB6",
    "C74A84BA3CB6CF359077EC05F39F091079F105517184DC224888F9A90FCCFAC7",
    "9B086CC1FBB51C1A3159F27112D0A16B62E64CDD2E750865BD0B5F240A2C2DCD",
    "5791439ACD9867820A85C49BA342494D2411C5B7EA4F2434206C4D4A81C70D45",
    "A5A48B3F1D15D4C0F051B8E5BC861C7A5E7FC6495C441ED2E2245F2F80FE6F77",
    "6E49DA6E7555A220F6453B3974CC471DB528AD9B2C1EFBAE88777E8621401487",
    "2CD18A41B66DDFEC0CBF7ECE8003937EC187DC34A3C058F599F961A0B30F4199",
    "3D8E55F97F632A1E8B7728196B1AE5C7DDB26EC9262A590029E9ACD4A4DF4508",
    "E81795062DEC8F96C349C58F4A8939D6E948EF4F5331FC53E993F3FBA292BDCB",
    "E5863414C3CEEA613282E9D88E560122B4307AA6706B3DE28B9728C427593AA9",
    "20C62725718FDA5C893B62BC72B9F4291E364729A1D2D63479856344907D35BC",
    "3690A9EA32E8F502A4044AFB71CD6482F1EE53C1A99E6078C64850B53E1ADABD",
    "E5C64D1FC54DB24A1A996FB128DEEE6CFB2857F1D7BEA497CC7422A16216A315",
    "B87124C5EAD616CA0177067196A21F10FFB3FDDCA6F2E1866FF320832D15FD13",
    "081E9404983B36C97459E010C09DFD486AC711D91EF2E033A9E6A1EF9FF4BC42",
    "9C84E9CCB2E785649F4565A6DCCEF5CA629255CF21E9501890499912EC42BEFB",
    "93A32AD30C9CCB784C47AAE2073914A70F55D34AB4BC7D92722B1E9FB4585A96",
    "67459F401A78CCEA65D967A7BB45143148507E7E750F291CF438AA53BB91BA03",
    "5C5838B87CB192041EB4C1AE2037AE3545807C1AB5BAAF1CF549A32946C55E7C",
    "ABE59B1F05B8176DC3DF4B11DC793E5DD7DC4D5DA7E087E71423D10FDDC90519",
    "20F06A6D5EC63E1B723EBD2784EC180265CDDC538879C62EAD6990AAB8CC5DB3",
    "3AC863940FAA760EBEC7E6F143142BFA0CA0687C06765F618B4128991E066084",
    "57A7C14A8BF87B52A7255B944649AD2434FDF8B5AA62E0D7AA67DE91935502A5",
    "F8AD4AA932E121BA8D5EC8DCAFFD39B1B8A9DAA1639CFAF404B7FEEFF4CD4956",
    "0989CDDF890F25BE1843467E0D7968A0F6781694050B621759646C1808CF7447",
    "6672E52320EFD77003AA29A91BAEFA709A54D00B85EBFCFE4644609E09DA091F",
    "E352A9D893CE5AABB4AF9D56752D1E021EE3614E5FC24DA43BD0F1AEAFA98281",
    "400A6916B4717FA84A5F02D2E2CB73CA1AAFC55282302C875EE346C9EC3BF01E",
    "7CA142A1E1FED2D5D31119219E0C1202A685F1079A2B366436F51C4B335EA5D7",
    "21633F30E9F13FD41199E1B3E3153F4A3FBDFF511DC2AF9BBBB63BBE16A3987A",
    "DD61594DE50775A2D67D9EAB40D9F7CCC9FD8CEE98005C3A2C18A88AB883D296",
    "34F3C0943A0F6A3AB9B6DD378186EE6499D5FC016DD2B5B7A2AB6D7BDB57F435",
    "95BF84AF92E9B5FEE5B8C459F989004E1506F6DEA27D5F0B4DDB865A68B0ECFB",
    "D7C123E94E73882D4DD5247C429C926348561C53A2554DA0D75E91CF3C6F022A",
    "C4145852D376E33E61AF17622AFCB68386739C45217D134969C45B8AA138A27F",
    "E442060B30A562225D9A8D6C0A307F131DD3DD0F6BC3CA44A01E0E4641C33190",
    "6D4DB6ED382A1E8E972DC30A65D5A9C06C06A9E428D9175A4E955AF833C352F0",
    "34F3C0943A0F6A3AB9B6DD378186EE6499D5FC016DD2B5B7A2AB6D7BDB57F435",
    "95BF84AF92E9B5FEE5B8C459F989004E1506F6DEA27D5F0B4DDB865A68B0ECFB",
    "D7C123E94E73882D4DD5247C429C926348561C53A2554DA0D75E91CF3C6F022A",
    "C4145852D376E33E61AF17622AFCB68386739C45217D134969C45B8AA138A27F",
    "E442060B30A562225D9A8D6C0A307F131DD3DD0F6BC3CA44A01E0E4641C33190",
    "94592DBF46E7050295368609BBFF6C47F92E9FF59C8510066B2C702C5E090844",
    "34F3C0943A0F6A3AB9B6DD378186EE6499D5FC016DD2B5B7A2AB6D7BDB57F435",
    "95BF84AF92E9B5FEE5B8C459F989004E1506F6DEA27D5F0B4DDB865A68B0ECFB",
    "D7C123E94E73882D4DD5247C429C926348561C53A2554DA0D75E91CF3C6F022A",
    "C4145852D376E33E61AF17622AFCB68386739C45217D134969C45B8AA138A27F",
    "E442060B30A562225D9A8D6C0A307F131DD3DD0F6BC3CA44A01E0E4641C33190",
    "62FE03161AC94AD9EBE6B336F6EDD1C4F709AED110F2A0918951793644B7542C",
    "B659FB2DA163274E3C7BE8B8CF3016585AAB5672C4665F3F26D40899045F6463",
    "C5CD06D9699B478623B86DC361FCE716E3FE8B096E9AEEAD073308AEB73AEA1B",
];
runGroupConversionToDistinctScanTests(db, queryHashes);
