/**
 * $group stages with only $top or only $bottom accumulators can sometimes be converted into a
 * DISTINCT_SCAN (see SERVER-84347). This optimization potentially applies to a $group when it
 * begins the pipeline or when it is preceded only by $match. In all cases, it must be possible to
 * do a DISTINCT_SCAN that sees each value of the distinct field exactly once among matching
 * documents and also provides any requested sort ('sortBy' field). The test queries below show most
 * $match/$group combinations where that is possible.
 *
 * @tags: [
 *   # The sharding and $facet passthrough suites modifiy aggregation pipelines in a way that
 *   # prevents the DISTINCT_SCAN optimization from being applied, which breaks the test.
 *   assumes_unsharded_collection,
 *   do_not_wrap_aggregations_in_facets,
 *   # Index filter commands do not support causal consistency.
 *   does_not_support_causal_consistency,
 *   requires_fcv_80,
 *   not_allowed_with_signed_security_token,
 * ]
 */

import {prepareCollection} from "jstests/libs/query/group_to_distinct_scan_utils.js";
import {
    runGroupWithTopBottomToDistinctScanTests
} from "jstests/libs/query/group_with_top_bottom_to_distinct_scan.js";

prepareCollection(db);
// Query hashes programmatically obtained for the subsequent tests.
// TODO SERVER-100039: replace this with passthrough suite for validating query hashes.
const queryHashes = [
    "CC57682B4F84F3850AB022E4C92CA661CDBB36F66A538D1E3BDD8EF18EBC6496",
    "D3479BD038D714EA157132DF7AE100FFF5F62CE302F6DE09509271CCB6FDA957",
    "C6DF0E93842C02EBFCC62D3F2E9E98BD8CB8E8BB34A22A7AF80242C515227EE0",
    "89438BA62DCCEE8D867ED634D84ACAD7E09195C5FC04D767AFC321E97FA35968",
    "2155CD83AEAE51899DA5DEFFA2C99666EF23DF4CDD3F79A3A4237131691654DB",
    "035EDE4B7F10705BEFC1088DB83888A6C138FE1DF9BFBC9311428346E8A01EC0",
    "A919696B402967A38F6A6A19718BB88EB1FEC7A82E6589AAE3B975BE4C68E0F2",
    "9D452E8CBF991D8EBB65091BD495F8C77B3A6F2AAD2605476BE5C05D16BEB131",
    "E07B332B339D55BF8CD42B009F2E05D94B496D5268AA49DDCC611ABE8011EE04",
    "8EA952EC8FA73ACFA1F1482B6D05DC5EAA15D8F466440ED6F260D82D3354850F",
    "4DD5E9E2C208E3845D9BA3FE713D8760764C11534B3D779F61E8DCAE23879DE8",
    "B7BF0F95EEB2A81A4E7AF9C90CBECBDE0C809DDC38A4F756B1AD561B6E4CF79D",
    "BA5E048DCE51BA50CF931D652A174BF2C7B1BF16571DF7D47E878BFC732E669D",
    "8F412D824B734356219F52245808BEDF19EF4540AF640AEFB856C954DFC34412",
    "EB4EC660AE4A5499239F31C73CC375DDAF306A3D54983F81611216E19EF6F371",
    "09645F2D53BD4B80006FCCB230C0E3288DCAEF49D8AFC27FFB21F25FB7B11685",
    "23BDD046A33E68C782EA811A767BAD654E0FA59C2313B0E815659B0E16E592C5",
    "E20C8E7DD77D81FCAF70D05FFF107D820DA5B010916216DCA353AB25DE71CA8E",
    "3861A0AC0BE3FA43A994B06BFD2A48D6E30F916F8A84059F499455DA1435A12E",
    "6A69F68E74522783DA65AC6348173C10554E5D7BB96B06D2FDF04D5CA05AC8FD",
    "4A454DF6162FF8DC85F49DBD0909470211DA2D9DA2AD164EC0DF977F80D5DCCF",
    "584C93082E35C4E0F2644A24057B3E2A2525951F9B77BA9116D3AEFD962A1B35",
    "8426B5EF4B802A653E62DC83B242C20E0BE97D7B5340BE84F3E1ED4ADDBB851E",
    "ACB75D728BDE7F3D49699CD7E80467E7F1C7897F77B04AB413C11369EE1DEDDE",
    "4F1214B68C58975799179ED2EB136BD0415326025A05F793ECA51800E1CF0BBC",
    "D894905FA2A20101E980E2B96996F9E4795674E6A9D88D5176F4171E9B6FAB93",
    "0601DB8600E5161BCA530ECE12967C2214CC3019F8CEFF9E15688FA17886BDA6",
    "E9E2D3034A92028BF82A98B5BCEFF505C505641BC8598D5116B70412BEEBC650",
    "37978AF9EC4DC91D1AB00546E70793E7F9D13A3932588119E0191A7BDA59D344",
    "0429187BE1EDFA3A8A3D8DD989927DE222EC91C86FD3A72CB1D9D972D8DF01D4",
    "CF4C613F8708AA08357DC5D0E0596CB589F96B4E0BE09ABED88B2F06390A9896",
    "790BADA3DE1DC44CDE7AE04016B712A3EEDC8F138DADFAFF6D0C72AFA86A5640",
    "44B5AA4A2E2478D8A0DEFE3683B675A9A58ECE107DC34D7733241DCF21F3E561",
    "C2D6E90C902AB90BB90D9B354436C4E252B005536B525A4C00CD8C47DA183C4C",
    "006C23DB1ABF2127A473A5232BBD6038BB385AE34355E6F690190526D7E58B70",
    "660427634E0E3D7459F31E159238F0B622D161ADDD3F3749C92545009FFB9D98",
    "AC690A01D79EF47748DAEB93ECC281A6EB9FBD3302A5730A4E09244006492C64",
    "9C785DA8B37011F03DAEBFDE853007AA2B99E34DB6015BE093A9A330E41007D4",
    "437A4A75D8E3B5C7C17BD2540F7E5937BB09CA2B67851EE9EDC37610406C9705",
    "8C85570ACC71E3FB96C1BE6E1B4D2253F32C95947C8AEE942D76645CCB0CE6E1",
    "9563AB7EB2A7849E4A83C5BE32B7FD77D57C0963ABF9D72C04646EDE571F3EF8",
    "9C785DA8B37011F03DAEBFDE853007AA2B99E34DB6015BE093A9A330E41007D4",
    "437A4A75D8E3B5C7C17BD2540F7E5937BB09CA2B67851EE9EDC37610406C9705",
    "8C85570ACC71E3FB96C1BE6E1B4D2253F32C95947C8AEE942D76645CCB0CE6E1",
    "4033FF8843C6C530553DD44DF957DEFCB074ABFC350F9E67C1E6479E890092C3",
    "9C785DA8B37011F03DAEBFDE853007AA2B99E34DB6015BE093A9A330E41007D4",
    "437A4A75D8E3B5C7C17BD2540F7E5937BB09CA2B67851EE9EDC37610406C9705",
    "8C85570ACC71E3FB96C1BE6E1B4D2253F32C95947C8AEE942D76645CCB0CE6E1",
    "9563AB7EB2A7849E4A83C5BE32B7FD77D57C0963ABF9D72C04646EDE571F3EF8"
];
runGroupWithTopBottomToDistinctScanTests(db, queryHashes);
