/**
 * Tests that shard filtering works as expected when the DISTINCT_SCAN optimization is applied to a
 * $group with the $top and $bottom accumulators.
 *
 * @tags: [
 *   featureFlagShardFilteringDistinctScan,
 *   do_not_wrap_aggregations_in_facets,
 *   not_allowed_with_signed_security_token,
 *   expects_explicit_underscore_id_index,
 *   # Index filter commands do not support causal consistency.
 *   does_not_support_causal_consistency,
 *   requires_fcv_82
 * ]
 */

import {
    prepareShardedCollectionWithOrphans
} from "jstests/libs/query/group_to_distinct_scan_utils.js";
import {
    runGroupWithTopBottomToDistinctScanTests
} from "jstests/libs/query/group_with_top_bottom_to_distinct_scan.js";
import {ShardingTest} from "jstests/libs/shardingtest.js";

TestData.skipCheckOrphans = true;

const st = new ShardingTest({shards: 2});
const db = prepareShardedCollectionWithOrphans(st);

// Query hashes programmatically obtained for the subsequent tests. Validated locally that these
// match the query shapes generated with featureFlagShardFilteringDistinctScan off, but we can't
// enable this test without this flag because of orphans.
// TODO SERVER-100039: replace this with passthrough suite for validating query hashes.
const queryHashes = [
    "D4EEA2924A5F22B1F7C2EC39535F55080DCED5E9D871CA5B8721C1D9A0BC061A",
    "AA7AC187256C37ABE07867D4C9C04A9C4EC9570C07DC9B8AA54208AF1ACB9AAB",
    "56B839556C0E20A80DC67E03B97BD142438D50E2B27CD8584A5ED3BAD2B2B191",
    "B6534700E647B88011ED28F89061BF830CA4E8DEFAF8463D62B7529A1798C1B3",
    "4C20C71562C4310C514C2499AE0E7E30060B5FF9471BC39A66BB05F05B208CFA",
    "4134FB4B573586CAA18BF12465CA3E49256C4B4E3A7BFE1AD44A6AB710BDA0EB",
    "6F2166A032BBC07395AE643253DBD2166C2A7A0EADD378BC95723788AC1842FB",
    "A25BE01ECFE73A54985B0EEAE70490E1FE5C6319C83CE4514459D504358B62D4",
    "5429D76A1BE3312D6AC4A9AE42EA9690403329E43886BF832E70D5DE3AC6C325",
    "7F1ACC1B5AE31817D0A62B649696C468A21C0EAB8D9527362BEBA88F043D7D6C",
    "0081AEB9E771A78836383FBF8797B6F1213E6DBC9CC47E84E86FBD73E61371AD",
    "27C258801F4B0D0F290ECE29D84D3DA5F325A58FC6458BEFF0A500FCC600CCDC",
    "842510A65E1C8472C19C1A50464AC2699911D140118651EA60232F5EA6955526",
    "04C4AD74E3F282AE358B1FADDB0CDBD094A3DCAECE8A273A497D1C5D20B88503",
    "786271BA40765EA0B992715CECA5F5A22F3A57C16C566FE87F4AFBFF0A1CCE60",
    "A3006336C9FD80BA5E0855402BE1B257EBA8A8558BEBD9CCFF48C758EB9DFACC",
    "B7877888E321A7849109D887B830DF768DDFD5B202CFC07813355E63C6E5E2E5",
    "5BED51E013D7D7892FDD801C26FC947CA8D480DCD4153307F4368F21C6D3DF23",
    "8A95381DFF5EFC6CB67076B8C018025B4F52F23BFF7E05C747B704CEA51DE2BA",
    "9C018E138E257C87500B4DF564EEE6468FA9E56CA8AB3E123C2B80E3D345A67E",
    "40C68AF936BFD69648E7DB02401255CFD7E1DEA34AFA6C34408586F3CDE2A778",
    "96BFE7108B2C67DA4FBAE8E5AD15A1F8F40F70327B553D1AF7CFCCC1440CAB70",
    "B1C23CD90FB16EFF0ADD42D6AAB019C3394050B8F57C513664E169E30109FF75",
    "DCC59DF2591842CCDBD5DEA58D71089DA6158D8BDF96DC8E609D383B3B7CD88C",
    "438B51C45F469DDB9303DEAFCAFB7E3268EC587FA08C8DDF46680FC5602525DD",
    "A10E697CBCA47CA70771DA25F7FC9FDC486DE92AD71FE0D0312BAE938DEC3CB2",
    "5FAA0B1EE37FA642080632E802D26C38D12C880CB2676D1E913B9BC053D3380A",
    "37E1328388C16DCA5E1F577931909B722D214EA62EE1FD3FC23D9E2A6E30989E",
    "C088FD4F17F2E1A13B1538474A45F9A7D5054C1B548C2A97E7A18300F2D2B339",
    "400105AB372616C4E01F0FA5C49C3944A61871290B45E3C8EF8DAD388501A339",
    "FE98DDC5571EF9845A4478EB7D375AB11E07CB79A85302F1B07C308AE8AA4A35",
    "C9D031901501674EB162BA08E532CF7F6CBA2670243E4CE7A51991F04A69A9A6",
    "3041DCD3C5595093A1508CD3848888E35955C045FCC138F7C86ECCC62293B0E8",
    "4E73A68249A21B20728541AD07A2A697EA6501CDBF51345E41C88DB7203696C0",
    "9241AC2EF0BEFD545786F24629EFF63500BBC721F75B290EB62E9D09A3DCD633",
    "8215E0DA96426D38D2FE693522AC86C3480CFBCDF211AE6DAA3750489B3005E2",
    "A315417B89ED75B22B2ED4B80962D07D684118528A9A014133C4CCE88163D169",
    "173B46C1157D70EB562ED234F9C0535A3ADDA4F1003B97047C4AD353C3203C4F",
    "4A1DAAC832BDBDC42970AD20DF98842CD3F73BD2077ADB674FF13DD759FF3EE5",
    "79EC48D414250515CAAD9F010E828B06D34CA27563653DD3203A63F038DD9DAF",
    "00F7C8E34316EB87677F499209C9A2B50329B9073B19F0AB0A0B058C33522BFB",
    "173B46C1157D70EB562ED234F9C0535A3ADDA4F1003B97047C4AD353C3203C4F",
    "4A1DAAC832BDBDC42970AD20DF98842CD3F73BD2077ADB674FF13DD759FF3EE5",
    "79EC48D414250515CAAD9F010E828B06D34CA27563653DD3203A63F038DD9DAF",
    "CE4622DE0DCAD72C8DB4D1CE552F697B4C1EDDBCB7DBAE59BCA6723C9B0AA1AE",
    "173B46C1157D70EB562ED234F9C0535A3ADDA4F1003B97047C4AD353C3203C4F",
    "4A1DAAC832BDBDC42970AD20DF98842CD3F73BD2077ADB674FF13DD759FF3EE5",
    "79EC48D414250515CAAD9F010E828B06D34CA27563653DD3203A63F038DD9DAF",
    "00F7C8E34316EB87677F499209C9A2B50329B9073B19F0AB0A0B058C33522BFB",
];
runGroupWithTopBottomToDistinctScanTests(db, queryHashes);

st.stop();
