/**
 *    Copyright (C) 2024-present MongoDB, Inc.
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the Server Side Public License, version 1,
 *    as published by MongoDB, Inc.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    Server Side Public License for more details.
 *
 *    You should have received a copy of the Server Side Public License
 *    along with this program. If not, see
 *    <http://www.mongodb.com/licensing/server-side-public-license>.
 *
 *    As a special exception, the copyright holders give permission to link the
 *    code of portions of this program with the OpenSSL library under certain
 *    conditions as described in each individual source file and distribute
 *    linked combinations including the program with the OpenSSL library. You
 *    must comply with the Server Side Public License in all respects for
 *    all of the code used other than as permitted herein. If you modify file(s)
 *    with this exception, you may extend this exception to your version of the
 *    file(s), but you are not obligated to do so. If you do not wish to do so,
 *    delete this exception statement from your version. If you delete this
 *    exception statement from all source files in the program, then also delete
 *    it in the license file.
 */

// this file was generated using code in
// https://github.com/10gen/ost1-misc/tree/master/my-app
//

{Decimal128(-100.000000),
 Decimal128(-100.000000),
 Decimal128(-1000000000000000L),
 Decimal128(0x7000000000000000L),
 1,
 R"(01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000000001
)"},

    {Decimal128(-100.000000),
     Decimal128(-100.000000),
     Decimal128(-1000000000000000L),
     Decimal128(0x7000000000000000L),
     8,
     R"(01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000000001
)"},

    {Decimal128(-100.000000),
     Decimal128(123456789.000000),
     Decimal128(-1000000000000000L),
     Decimal128(0x7000000000000000L),
     1,
     R"(01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000000001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000000000000110000000001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000011000000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000000000000110000001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000011000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000000000000110001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000011001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000000000000111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000000000001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000000001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110111
0101000111000100111101111100100000110110010100111110010101110111010010100101011111
01010001110001001111011111001000001101100101001111100101011101110100101001011
010100011100010011110111110010000011011001010011111001010111011101001010011
0101000111000100111101111100100000110110010100111110010101110111010010101
010100011100010011110111110010000011011001010011111001010111011101001011
0101000111000100111101111100100000110110010100111110010101110111010011
01010001110001001111011111001000001101100101001111100101011101110101
0101000111000100111101111100100000110110010100111110010101110111011
01010001110001001111011111001000001101100101001111100101011101111
0101000111000100111101111100100000110110010100111110010101111
010100011100010011110111110010000011011001010011111001011
0101000111000100111101111100100000110110010100111110011
01010001110001001111011111001000001101100101001111101
0101000111000100111101111100100000110110010100111111
0101000111000100111101111100100000110110010101
010100011100010011110111110010000011011001011
0101000111000100111101111100100000110110011
01010001110001001111011111001000001101101
0101000111000100111101111100100000110111
0101000111000100111101111100100000111
0101000111000100111101111100100001
010100011100010011110111110010001
01010001110001001111011111001001
0101000111000100111101111100101
010100011100010011110111110011
0101000111000100111101111101
010100011100010011110111111
010100011100010011111
0101000111000101
010100011100011
0101000111001
010100011101
01010001111
0101001
010101
01011
011
100
10100
101010
1010110
1010111000
10101110010000
101011100100010
10101110010001100
1010111001000110100
10101110010001101010000
1010111001000110101000100000000
101011100100011010100010000000100
1010111001000110101000100000001010
10101110010001101010001000000010110
1010111001000110101000100000001011100
101011100100011010100010000000101110100
1010111001000110101000100000001011101010
101011100100011010100010000000101110101100
1010111001000110101000100000001011101011010
10101110010001101010001000000010111010110110
101011100100011010100010000000101110101101110
101011100100011010100010000000101110101101111000000
1010111001000110101000100000001011101011011110000010
10101110010001101010001000000010111010110111100000110
101011100100011010100010000000101110101101111000001110000
10101110010001101010001000000010111010110111100000111000100000
1010111001000110101000100000001011101011011110000011100010000100
101011100100011010100010000000101110101101111000001110001000010100000
1010111001000110101000100000001011101011011110000011100010000101000010
101011100100011010100010000000101110101101111000001110001000010100001100
1010111001000110101000100000001011101011011110000011100010000101000011010
1010111001000110101000100000001011101011011110000011100010000101000011011000
10101110010001101010001000000010111010110111100000111000100001010000110110010
1010111001000110101000100000001011101011011110000011100010000101000011011001100
10101110010001101010001000000010111010110111100000111000100001010000110110011010
101011100100011010100010000000101110101101111000001110001000010100001101100110110
101011100100011010100010000000101110101101111000001110001000010100001101100110111000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111111110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111111111110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111111111111000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111100110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111111111111001110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111100111110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111111111111001111110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111111111111001111111100
)"},

    {Decimal128(-100.000000),
     Decimal128(123456789.000000),
     Decimal128(-1000000000000000L),
     Decimal128(0x7000000000000000L),
     8,
     std::string(
         R"(01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000000010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000000011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000000100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000000101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000000110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000000111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000001000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000001001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000001010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000001011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000001100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000001101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000001110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000001111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000010000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000010001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000010010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000010011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000010100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000010101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000010110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000010111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000011000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000011001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000011010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000011011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000011100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000011101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000011110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000011111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000100000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000100001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000100010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000100011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000100100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000100101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000100110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000100111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000101000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000101001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000101010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000101011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000101100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000101101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000101110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000101111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000110000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000110001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000110010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000110011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000110100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000110101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000110110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000110111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000111000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000111001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000111010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000111011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000111100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000111101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000111110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100000111111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001000000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001000010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001000011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001000100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001000101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001000110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001000111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001001000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001001001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001001010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001001011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001001100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001001101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001001110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001001111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001010000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001010001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001010010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001010011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001010100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001010101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001010110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001010111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001011000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001011001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001011010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001011011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001011100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001011101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001011110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001011111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001100000
)") +
         R"(01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001100001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001100010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001100011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001100100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001100101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001100110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001100111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001101000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001101001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001101010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001101011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001101100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001101101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001101110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001101111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001110000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001110001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001110010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001110011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001110100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001110101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001110110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001110111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001111000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001111001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001111010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001111011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001111100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001111101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001111110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100001111111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010000000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010000010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010000011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010000100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010000101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010000110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010000111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010001000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010001001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010001010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010001011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010001100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010001101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010001110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010001111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010010000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010010001
)" +
         R"(01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010010010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010010011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010010100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010010101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010010110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010010111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010011000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010011001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010011010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010011011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010011100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010011101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010011110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010011111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010100000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010100001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010100010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010100011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010100100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010100101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010100110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010100111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010101000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010101001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010101010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010101011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010101100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010101101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010101110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010101111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010110000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010110001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010110010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010110011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010110100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010110101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010110110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010110111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010111000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010111001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010111010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010111011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010111100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010111101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010111110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100010111111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011000000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011000010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011000011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011000100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011000101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011000110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011000111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011001000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011001001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011001010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011001011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011001100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011001101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011001110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011001111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011010000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011010001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011010010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011010011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011010100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011010101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011010110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011010111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011011000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011011001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011011010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011011011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011011100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011011101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011011110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011011111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011100000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011100001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011100010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011100011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011100100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011100101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011100110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011100111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011101000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011101001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011101010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011101011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011101100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011101101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011101110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011101111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011110000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011110001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011110010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011110011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011110100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011110101
)" +
         R"(01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011110110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011110111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011111000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011111001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011111010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011111011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011111100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011111101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011111110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000000000000000001100011111111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000011001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000011010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000011011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000011100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000011101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000011110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000011111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000100000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000100001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000100010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000100011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000100100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000100101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000100110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000100111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000101000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000101001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000101010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000101011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000101100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000101101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000101110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000101111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000110000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000110001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000110010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000110011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000110100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000110101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000110110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000110111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000111000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000111001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000111010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000111011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000111100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000111101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000111110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000000111111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001000000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001000001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001000010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001000011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001000100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001000101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001000110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001000111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001001000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001001001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001001010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001001011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001001100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001001101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001001110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001001111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001010000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001010001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001010010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001010011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001010100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001010101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001010110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001010111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001011000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001011001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001011010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001011011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001011100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001011101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001011110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001011111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001100000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001100001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001100010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001100011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001100100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001100101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001100110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001100111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001101000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001101001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001101010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001101011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001101100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001101101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001101110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001101111
)" +
         R"(010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001110000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001110001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001110010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001110011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001110100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001110101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001110110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001110111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001111000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001111001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001111010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001111011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001111100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001111101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001111110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000001111111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010000000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010000001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010000010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010000011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010000100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010000101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010000110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010000111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010001000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010001001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010001010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010001011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010001100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010001101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010001110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010001111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010010000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010010001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010010010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010010011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010010100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010010101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010010110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010010111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010011000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010011001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010011010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010011011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010011100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010011101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010011110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010011111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010100000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010100001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010100010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010100011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010100100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010100101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010100110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010100111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010101000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010101001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010101010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010101011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010101100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010101101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010101110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010101111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010110000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010110001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010110010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010110011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010110100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010110101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010110110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010110111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010111000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010111001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010111010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010111011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010111100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010111101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010111110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000010111111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011000000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011000001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011000010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011000011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011000100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011000101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011000110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011000111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011001000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011001001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011001010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011001011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011001100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011001101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011001110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011001111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011010000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011010001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011010010
)" +
         R"(010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011010011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011010100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011010101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011010110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011010111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011011000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011011001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011011010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011011011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011011100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011011101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011011110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011011111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011100000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011100001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011100010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011100011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011100100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011100101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011100110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011100111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011101000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011101001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011101010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011101011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011101100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011101101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011101110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011101111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011110000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011110001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011110010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011110011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011110100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011110101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011110110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011110111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011111000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011111001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011111010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011111011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011111100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011111101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011111110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010010000000000000000011111111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000000001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000000010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000000011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000000100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000000101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000000110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000000111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000001000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000001001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000001010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000001011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000001100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000001101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000001110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000001111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000010000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000010001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000010010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000010011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000010100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000010101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000010110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000010111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000011000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000011001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000011010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000011011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000011100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000011101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000011110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000011111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000100000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000100001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000100010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000100011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000100100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000100101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000100110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000100111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000101000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000101001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000101010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000101011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000101100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000101101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000101110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000101111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000110000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000110001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000110010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000110011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000110100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000110101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000110110
)" +
         R"(0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000110111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000111000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000111001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000111010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000111011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000111100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000111101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000111110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000000111111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001000000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001000001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001000010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001000011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001000100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001000101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001000110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001000111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001001000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001001001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001001010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001001011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001001100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001001101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001001110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001001111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001010000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001010001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001010010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001010011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001010100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001010101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001010110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001010111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001011000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001011001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001011010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001011011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001011100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001011101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001011110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001011111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001100000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001100001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001100010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001100011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001100100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001100101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001100110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001100111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001101000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001101001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001101010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001101011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001101100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001101101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001101110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001101111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001110000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001110001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001110010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001110011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001110100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001110101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001110110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001110111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001111000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001111001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001111010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001111011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001111100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001111101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001111110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000001111111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010000000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010000001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010000010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010000011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010000100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010000101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010000110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010000111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010001000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010001001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010001010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010001011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010001100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010001101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010001110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010001111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010010000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010010001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010010010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010010011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010010100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010010101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010010110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010010111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010011000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010011001
)" +
         R"(0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010011010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010011011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010011100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010011101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010011110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010011111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010100000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010100001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010100010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010100011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010100100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010100101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010100110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010100111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010101000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010101001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010101010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010101011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010101100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010101101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010101110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010101111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010110000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010110001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010110010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010110011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010110100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010110101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010110110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010110111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010111000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010111001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010111010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010111011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010111100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010111101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010111110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000010111111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011000000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011000001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011000010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011000011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011000100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011000101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011000110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011000111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011001000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011001001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011001010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011001011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011001100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011001101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011001110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011001111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011010000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011010001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011010010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011010011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011010100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011010101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011010110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011010111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011011000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011011001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011011010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011011011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011011100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011011101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011011110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011011111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011100000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011100001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011100010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011100011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011100100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011100101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011100110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011100111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011101000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011101001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011101010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011101011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011101100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011101101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011101110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011101111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011110000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011110001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011110010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011110011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011110100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011110101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011110110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011110111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011111000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011111001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011111010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011111011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011111100
)" +
         R"(0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011111101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011111110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110110100100100000000011111111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000000111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000001000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000001001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000001010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000001011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000001100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000001101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000001110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000001111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000010000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000010001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000010010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000010011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000010100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000010101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000010110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000010111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000011000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000011001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000011010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000011011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000011100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000011101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000011110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000011111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000100000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000100001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000100010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000100011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000100100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000100101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000100110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000100111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000101000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000101001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000101010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000101011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000101100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000101101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000101110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000101111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000110000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000110001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000110010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000110011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000110100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000110101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000110110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000110111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000111000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000111001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000111010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000111011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000111100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000111101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000111110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001000111111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001000000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001000010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001000011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001000100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001000101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001000110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001000111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001001000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001001001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001001010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001001011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001001100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001001101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001001110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001001111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001010000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001010001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001010010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001010011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001010100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001010101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001010110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001010111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001011000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001011001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001011010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001011011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001011100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001011101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001011110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001011111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001100000
)" +
         R"(01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001100001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001100010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001100011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001100100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001100101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001100110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001100111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001101000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001101001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001101010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001101011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001101100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001101101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001101110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001101111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001110000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001110001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001110010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001110011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001110100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001110101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001110110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001110111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001111000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001111001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001111010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001111011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001111100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001111101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001111110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001001111111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010000000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010000010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010000011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010000100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010000101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010000110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010000111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010001000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010001001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010001010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010001011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010001100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010001101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010001110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010001111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010010000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010010001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010010010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010010011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010010100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010010101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010010110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010010111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010011000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010011001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010011010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010011011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010011100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010011101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010011110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010011111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010100000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010100001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010100010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010100011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010100100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010100101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010100110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010100111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010101000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010101001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010101010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010101011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010101100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010101101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010101110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010101111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010110000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010110001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010110010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010110011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010110100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010110101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010110110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010110111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010111000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010111001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010111010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010111011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010111100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010111101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010111110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001010111111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011000000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011000001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011000010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011000011
)" +
         R"(01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011000100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011000101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011000110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011000111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011001000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011001001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011001010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011001011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011001100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011001101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011001110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011001111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011010000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011010001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011010010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011010011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011010100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011010101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011010110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011010111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011011000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011011001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011011010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011011011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011011100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011011101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011011110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011011111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011100000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011100001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011100010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011100011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011100100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011100101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011100110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011100111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011101000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011101001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011101010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011101011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011101100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011101101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011101110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011101111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011110000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011110001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011110010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011110011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011110100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011110101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011110110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011110111
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011111000
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011111001
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011111010
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011111011
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011111100
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011111101
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011111110
01010001110001001111011111001000001101100101001111100101011101110100101001010111101101101001001011111111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010010111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010011000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010011001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010011010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010011011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010011100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010011101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010011110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010011111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010100000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010100001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010100010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010100011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010100100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010100101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010100110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010100111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010101000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010101001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010101010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010101011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010101100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010101101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010101110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010101111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010110000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010110001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010110010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010110011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010110100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010110101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010110110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010110111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010111000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010111001
)" +
         R"(010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010111010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010111011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010111100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010111101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010111110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011010111111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011000000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011000001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011000010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011000011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011000100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011000101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011000110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011000111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011001000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011001001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011001010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011001011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011001100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011001101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011001110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011001111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011010000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011010001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011010010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011010011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011010100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011010101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011010110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011010111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011011000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011011001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011011010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011011011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011011100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011011101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011011110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011011111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011100000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011100001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011100010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011100011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011100100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011100101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011100110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011100111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011101000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011101001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011101010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011101011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011101100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011101101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011101110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011101111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011110000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011110001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011110010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011110011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011110100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011110101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011110110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011110111
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011111000
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011111001
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011111010
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011111011
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011111100
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011111101
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011111110
010100011100010011110111110010000011011001010011111001010111011101001010010101111011011011111111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110110111
0101000111000100111101111100100000110110010100111110010101110111010010100101011110111000
0101000111000100111101111100100000110110010100111110010101110111010010100101011110111001
0101000111000100111101111100100000110110010100111110010101110111010010100101011110111010
0101000111000100111101111100100000110110010100111110010101110111010010100101011110111011
0101000111000100111101111100100000110110010100111110010101110111010010100101011110111100
0101000111000100111101111100100000110110010100111110010101110111010010100101011110111101
0101000111000100111101111100100000110110010100111110010101110111010010100101011110111110
0101000111000100111101111100100000110110010100111110010101110111010010100101011110111111
0101000111000100111101111100100000110110010100111110010101110111010010100101011111000000
0101000111000100111101111100100000110110010100111110010101110111010010100101011111000001
0101000111000100111101111100100000110110010100111110010101110111010010100101011111000010
0101000111000100111101111100100000110110010100111110010101110111010010100101011111000011
0101000111000100111101111100100000110110010100111110010101110111010010100101011111000100
0101000111000100111101111100100000110110010100111110010101110111010010100101011111000101
0101000111000100111101111100100000110110010100111110010101110111010010100101011111000110
0101000111000100111101111100100000110110010100111110010101110111010010100101011111000111
0101000111000100111101111100100000110110010100111110010101110111010010100101011111001000
0101000111000100111101111100100000110110010100111110010101110111010010100101011111001001
0101000111000100111101111100100000110110010100111110010101110111010010100101011111001010
0101000111000100111101111100100000110110010100111110010101110111010010100101011111001011
0101000111000100111101111100100000110110010100111110010101110111010010100101011111001100
0101000111000100111101111100100000110110010100111110010101110111010010100101011111001101
0101000111000100111101111100100000110110010100111110010101110111010010100101011111001110
0101000111000100111101111100100000110110010100111110010101110111010010100101011111001111
0101000111000100111101111100100000110110010100111110010101110111010010100101011111010000
0101000111000100111101111100100000110110010100111110010101110111010010100101011111010001
0101000111000100111101111100100000110110010100111110010101110111010010100101011111010010
0101000111000100111101111100100000110110010100111110010101110111010010100101011111010011
)" +
         R"(0101000111000100111101111100100000110110010100111110010101110111010010100101011111010100
0101000111000100111101111100100000110110010100111110010101110111010010100101011111010101
0101000111000100111101111100100000110110010100111110010101110111010010100101011111010110
0101000111000100111101111100100000110110010100111110010101110111010010100101011111010111
0101000111000100111101111100100000110110010100111110010101110111010010100101011111011000
0101000111000100111101111100100000110110010100111110010101110111010010100101011111011001
0101000111000100111101111100100000110110010100111110010101110111010010100101011111011010
0101000111000100111101111100100000110110010100111110010101110111010010100101011111011011
0101000111000100111101111100100000110110010100111110010101110111010010100101011111011100
0101000111000100111101111100100000110110010100111110010101110111010010100101011111011101
0101000111000100111101111100100000110110010100111110010101110111010010100101011111011110
0101000111000100111101111100100000110110010100111110010101110111010010100101011111011111
0101000111000100111101111100100000110110010100111110010101110111010010100101011111100000
0101000111000100111101111100100000110110010100111110010101110111010010100101011111100001
0101000111000100111101111100100000110110010100111110010101110111010010100101011111100010
0101000111000100111101111100100000110110010100111110010101110111010010100101011111100011
0101000111000100111101111100100000110110010100111110010101110111010010100101011111100100
0101000111000100111101111100100000110110010100111110010101110111010010100101011111100101
0101000111000100111101111100100000110110010100111110010101110111010010100101011111100110
0101000111000100111101111100100000110110010100111110010101110111010010100101011111100111
0101000111000100111101111100100000110110010100111110010101110111010010100101011111101000
0101000111000100111101111100100000110110010100111110010101110111010010100101011111101001
0101000111000100111101111100100000110110010100111110010101110111010010100101011111101010
0101000111000100111101111100100000110110010100111110010101110111010010100101011111101011
0101000111000100111101111100100000110110010100111110010101110111010010100101011111101100
0101000111000100111101111100100000110110010100111110010101110111010010100101011111101101
0101000111000100111101111100100000110110010100111110010101110111010010100101011111101110
0101000111000100111101111100100000110110010100111110010101110111010010100101011111101111
0101000111000100111101111100100000110110010100111110010101110111010010100101011111110000
0101000111000100111101111100100000110110010100111110010101110111010010100101011111110001
0101000111000100111101111100100000110110010100111110010101110111010010100101011111110010
0101000111000100111101111100100000110110010100111110010101110111010010100101011111110011
0101000111000100111101111100100000110110010100111110010101110111010010100101011111110100
0101000111000100111101111100100000110110010100111110010101110111010010100101011111110101
0101000111000100111101111100100000110110010100111110010101110111010010100101011111110110
0101000111000100111101111100100000110110010100111110010101110111010010100101011111110111
0101000111000100111101111100100000110110010100111110010101110111010010100101011111111000
0101000111000100111101111100100000110110010100111110010101110111010010100101011111111001
0101000111000100111101111100100000110110010100111110010101110111010010100101011111111010
0101000111000100111101111100100000110110010100111110010101110111010010100101011111111011
0101000111000100111101111100100000110110010100111110010101110111010010100101011111111100
0101000111000100111101111100100000110110010100111110010101110111010010100101011111111101
0101000111000100111101111100100000110110010100111110010101110111010010100101011111111110
0101000111000100111101111100100000110110010100111110010101110111010010100101011111111111
01010001110001001111011111001000001101100101001111100101011101110100101001011000
01010001110001001111011111001000001101100101001111100101011101110100101001011001
01010001110001001111011111001000001101100101001111100101011101110100101001011010
01010001110001001111011111001000001101100101001111100101011101110100101001011011
01010001110001001111011111001000001101100101001111100101011101110100101001011100
01010001110001001111011111001000001101100101001111100101011101110100101001011101
01010001110001001111011111001000001101100101001111100101011101110100101001011110
01010001110001001111011111001000001101100101001111100101011101110100101001011111
01010001110001001111011111001000001101100101001111100101011101110100101001100000
01010001110001001111011111001000001101100101001111100101011101110100101001100001
01010001110001001111011111001000001101100101001111100101011101110100101001100010
01010001110001001111011111001000001101100101001111100101011101110100101001100011
01010001110001001111011111001000001101100101001111100101011101110100101001100100
01010001110001001111011111001000001101100101001111100101011101110100101001100101
01010001110001001111011111001000001101100101001111100101011101110100101001100110
01010001110001001111011111001000001101100101001111100101011101110100101001100111
01010001110001001111011111001000001101100101001111100101011101110100101001101000
01010001110001001111011111001000001101100101001111100101011101110100101001101001
01010001110001001111011111001000001101100101001111100101011101110100101001101010
01010001110001001111011111001000001101100101001111100101011101110100101001101011
01010001110001001111011111001000001101100101001111100101011101110100101001101100
01010001110001001111011111001000001101100101001111100101011101110100101001101101
01010001110001001111011111001000001101100101001111100101011101110100101001101110
01010001110001001111011111001000001101100101001111100101011101110100101001101111
01010001110001001111011111001000001101100101001111100101011101110100101001110000
01010001110001001111011111001000001101100101001111100101011101110100101001110001
01010001110001001111011111001000001101100101001111100101011101110100101001110010
01010001110001001111011111001000001101100101001111100101011101110100101001110011
01010001110001001111011111001000001101100101001111100101011101110100101001110100
01010001110001001111011111001000001101100101001111100101011101110100101001110101
01010001110001001111011111001000001101100101001111100101011101110100101001110110
01010001110001001111011111001000001101100101001111100101011101110100101001110111
01010001110001001111011111001000001101100101001111100101011101110100101001111000
01010001110001001111011111001000001101100101001111100101011101110100101001111001
01010001110001001111011111001000001101100101001111100101011101110100101001111010
01010001110001001111011111001000001101100101001111100101011101110100101001111011
01010001110001001111011111001000001101100101001111100101011101110100101001111100
01010001110001001111011111001000001101100101001111100101011101110100101001111101
01010001110001001111011111001000001101100101001111100101011101110100101001111110
01010001110001001111011111001000001101100101001111100101011101110100101001111111
01010001110001001111011111001000001101100101001111100101011101110100101010000000
01010001110001001111011111001000001101100101001111100101011101110100101010000001
01010001110001001111011111001000001101100101001111100101011101110100101010000010
01010001110001001111011111001000001101100101001111100101011101110100101010000011
01010001110001001111011111001000001101100101001111100101011101110100101010000100
01010001110001001111011111001000001101100101001111100101011101110100101010000101
01010001110001001111011111001000001101100101001111100101011101110100101010000110
01010001110001001111011111001000001101100101001111100101011101110100101010000111
01010001110001001111011111001000001101100101001111100101011101110100101010001000
01010001110001001111011111001000001101100101001111100101011101110100101010001001
01010001110001001111011111001000001101100101001111100101011101110100101010001010
01010001110001001111011111001000001101100101001111100101011101110100101010001011
01010001110001001111011111001000001101100101001111100101011101110100101010001100
01010001110001001111011111001000001101100101001111100101011101110100101010001101
01010001110001001111011111001000001101100101001111100101011101110100101010001110
)" +
         R"(01010001110001001111011111001000001101100101001111100101011101110100101010001111
01010001110001001111011111001000001101100101001111100101011101110100101010010000
01010001110001001111011111001000001101100101001111100101011101110100101010010001
01010001110001001111011111001000001101100101001111100101011101110100101010010010
01010001110001001111011111001000001101100101001111100101011101110100101010010011
01010001110001001111011111001000001101100101001111100101011101110100101010010100
01010001110001001111011111001000001101100101001111100101011101110100101010010101
01010001110001001111011111001000001101100101001111100101011101110100101010010110
01010001110001001111011111001000001101100101001111100101011101110100101010010111
01010001110001001111011111001000001101100101001111100101011101110100101010011000
01010001110001001111011111001000001101100101001111100101011101110100101010011001
01010001110001001111011111001000001101100101001111100101011101110100101010011010
01010001110001001111011111001000001101100101001111100101011101110100101010011011
01010001110001001111011111001000001101100101001111100101011101110100101010011100
01010001110001001111011111001000001101100101001111100101011101110100101010011101
01010001110001001111011111001000001101100101001111100101011101110100101010011110
01010001110001001111011111001000001101100101001111100101011101110100101010011111
01010001110001001111011111001000001101100101001111100101011101110100101010100000
01010001110001001111011111001000001101100101001111100101011101110100101010100001
01010001110001001111011111001000001101100101001111100101011101110100101010100010
01010001110001001111011111001000001101100101001111100101011101110100101010100011
01010001110001001111011111001000001101100101001111100101011101110100101010100100
01010001110001001111011111001000001101100101001111100101011101110100101010100101
01010001110001001111011111001000001101100101001111100101011101110100101010100110
01010001110001001111011111001000001101100101001111100101011101110100101010100111
01010001110001001111011111001000001101100101001111100101011101110100101010101000
01010001110001001111011111001000001101100101001111100101011101110100101010101001
01010001110001001111011111001000001101100101001111100101011101110100101010101010
01010001110001001111011111001000001101100101001111100101011101110100101010101011
01010001110001001111011111001000001101100101001111100101011101110100101010101100
01010001110001001111011111001000001101100101001111100101011101110100101010101101
01010001110001001111011111001000001101100101001111100101011101110100101010101110
01010001110001001111011111001000001101100101001111100101011101110100101010101111
01010001110001001111011111001000001101100101001111100101011101110100101010110000
01010001110001001111011111001000001101100101001111100101011101110100101010110001
01010001110001001111011111001000001101100101001111100101011101110100101010110010
01010001110001001111011111001000001101100101001111100101011101110100101010110011
01010001110001001111011111001000001101100101001111100101011101110100101010110100
01010001110001001111011111001000001101100101001111100101011101110100101010110101
01010001110001001111011111001000001101100101001111100101011101110100101010110110
01010001110001001111011111001000001101100101001111100101011101110100101010110111
01010001110001001111011111001000001101100101001111100101011101110100101010111000
01010001110001001111011111001000001101100101001111100101011101110100101010111001
01010001110001001111011111001000001101100101001111100101011101110100101010111010
01010001110001001111011111001000001101100101001111100101011101110100101010111011
01010001110001001111011111001000001101100101001111100101011101110100101010111100
01010001110001001111011111001000001101100101001111100101011101110100101010111101
01010001110001001111011111001000001101100101001111100101011101110100101010111110
01010001110001001111011111001000001101100101001111100101011101110100101010111111
01010001110001001111011111001000001101100101001111100101011101110100101011000000
01010001110001001111011111001000001101100101001111100101011101110100101011000001
01010001110001001111011111001000001101100101001111100101011101110100101011000010
01010001110001001111011111001000001101100101001111100101011101110100101011000011
01010001110001001111011111001000001101100101001111100101011101110100101011000100
01010001110001001111011111001000001101100101001111100101011101110100101011000101
01010001110001001111011111001000001101100101001111100101011101110100101011000110
01010001110001001111011111001000001101100101001111100101011101110100101011000111
01010001110001001111011111001000001101100101001111100101011101110100101011001000
01010001110001001111011111001000001101100101001111100101011101110100101011001001
01010001110001001111011111001000001101100101001111100101011101110100101011001010
01010001110001001111011111001000001101100101001111100101011101110100101011001011
01010001110001001111011111001000001101100101001111100101011101110100101011001100
01010001110001001111011111001000001101100101001111100101011101110100101011001101
01010001110001001111011111001000001101100101001111100101011101110100101011001110
01010001110001001111011111001000001101100101001111100101011101110100101011001111
01010001110001001111011111001000001101100101001111100101011101110100101011010000
01010001110001001111011111001000001101100101001111100101011101110100101011010001
01010001110001001111011111001000001101100101001111100101011101110100101011010010
01010001110001001111011111001000001101100101001111100101011101110100101011010011
01010001110001001111011111001000001101100101001111100101011101110100101011010100
01010001110001001111011111001000001101100101001111100101011101110100101011010101
01010001110001001111011111001000001101100101001111100101011101110100101011010110
01010001110001001111011111001000001101100101001111100101011101110100101011010111
01010001110001001111011111001000001101100101001111100101011101110100101011011000
01010001110001001111011111001000001101100101001111100101011101110100101011011001
01010001110001001111011111001000001101100101001111100101011101110100101011011010
01010001110001001111011111001000001101100101001111100101011101110100101011011011
01010001110001001111011111001000001101100101001111100101011101110100101011011100
01010001110001001111011111001000001101100101001111100101011101110100101011011101
01010001110001001111011111001000001101100101001111100101011101110100101011011110
01010001110001001111011111001000001101100101001111100101011101110100101011011111
01010001110001001111011111001000001101100101001111100101011101110100101011100000
01010001110001001111011111001000001101100101001111100101011101110100101011100001
01010001110001001111011111001000001101100101001111100101011101110100101011100010
01010001110001001111011111001000001101100101001111100101011101110100101011100011
01010001110001001111011111001000001101100101001111100101011101110100101011100100
01010001110001001111011111001000001101100101001111100101011101110100101011100101
01010001110001001111011111001000001101100101001111100101011101110100101011100110
01010001110001001111011111001000001101100101001111100101011101110100101011100111
01010001110001001111011111001000001101100101001111100101011101110100101011101000
01010001110001001111011111001000001101100101001111100101011101110100101011101001
01010001110001001111011111001000001101100101001111100101011101110100101011101010
01010001110001001111011111001000001101100101001111100101011101110100101011101011
01010001110001001111011111001000001101100101001111100101011101110100101011101100
01010001110001001111011111001000001101100101001111100101011101110100101011101101
01010001110001001111011111001000001101100101001111100101011101110100101011101110
01010001110001001111011111001000001101100101001111100101011101110100101011101111
01010001110001001111011111001000001101100101001111100101011101110100101011110000
01010001110001001111011111001000001101100101001111100101011101110100101011110001
)" +
         R"(01010001110001001111011111001000001101100101001111100101011101110100101011110010
01010001110001001111011111001000001101100101001111100101011101110100101011110011
01010001110001001111011111001000001101100101001111100101011101110100101011110100
01010001110001001111011111001000001101100101001111100101011101110100101011110101
01010001110001001111011111001000001101100101001111100101011101110100101011110110
01010001110001001111011111001000001101100101001111100101011101110100101011110111
01010001110001001111011111001000001101100101001111100101011101110100101011111000
01010001110001001111011111001000001101100101001111100101011101110100101011111001
01010001110001001111011111001000001101100101001111100101011101110100101011111010
01010001110001001111011111001000001101100101001111100101011101110100101011111011
01010001110001001111011111001000001101100101001111100101011101110100101011111100
01010001110001001111011111001000001101100101001111100101011101110100101011111101
01010001110001001111011111001000001101100101001111100101011101110100101011111110
01010001110001001111011111001000001101100101001111100101011101110100101011111111
010100011100010011110111110010000011011001010011111001010111011101001011
010100011100010011110111110010000011011001010011111001010111011101001100
010100011100010011110111110010000011011001010011111001010111011101001101
010100011100010011110111110010000011011001010011111001010111011101001110
010100011100010011110111110010000011011001010011111001010111011101001111
010100011100010011110111110010000011011001010011111001010111011101010000
010100011100010011110111110010000011011001010011111001010111011101010001
010100011100010011110111110010000011011001010011111001010111011101010010
010100011100010011110111110010000011011001010011111001010111011101010011
010100011100010011110111110010000011011001010011111001010111011101010100
010100011100010011110111110010000011011001010011111001010111011101010101
010100011100010011110111110010000011011001010011111001010111011101010110
010100011100010011110111110010000011011001010011111001010111011101010111
010100011100010011110111110010000011011001010011111001010111011101011000
010100011100010011110111110010000011011001010011111001010111011101011001
010100011100010011110111110010000011011001010011111001010111011101011010
010100011100010011110111110010000011011001010011111001010111011101011011
010100011100010011110111110010000011011001010011111001010111011101011100
010100011100010011110111110010000011011001010011111001010111011101011101
010100011100010011110111110010000011011001010011111001010111011101011110
010100011100010011110111110010000011011001010011111001010111011101011111
010100011100010011110111110010000011011001010011111001010111011101100000
010100011100010011110111110010000011011001010011111001010111011101100001
010100011100010011110111110010000011011001010011111001010111011101100010
010100011100010011110111110010000011011001010011111001010111011101100011
010100011100010011110111110010000011011001010011111001010111011101100100
010100011100010011110111110010000011011001010011111001010111011101100101
010100011100010011110111110010000011011001010011111001010111011101100110
010100011100010011110111110010000011011001010011111001010111011101100111
010100011100010011110111110010000011011001010011111001010111011101101000
010100011100010011110111110010000011011001010011111001010111011101101001
010100011100010011110111110010000011011001010011111001010111011101101010
010100011100010011110111110010000011011001010011111001010111011101101011
010100011100010011110111110010000011011001010011111001010111011101101100
010100011100010011110111110010000011011001010011111001010111011101101101
010100011100010011110111110010000011011001010011111001010111011101101110
010100011100010011110111110010000011011001010011111001010111011101101111
010100011100010011110111110010000011011001010011111001010111011101110000
010100011100010011110111110010000011011001010011111001010111011101110001
010100011100010011110111110010000011011001010011111001010111011101110010
010100011100010011110111110010000011011001010011111001010111011101110011
010100011100010011110111110010000011011001010011111001010111011101110100
010100011100010011110111110010000011011001010011111001010111011101110101
010100011100010011110111110010000011011001010011111001010111011101110110
010100011100010011110111110010000011011001010011111001010111011101110111
010100011100010011110111110010000011011001010011111001010111011101111000
010100011100010011110111110010000011011001010011111001010111011101111001
010100011100010011110111110010000011011001010011111001010111011101111010
010100011100010011110111110010000011011001010011111001010111011101111011
010100011100010011110111110010000011011001010011111001010111011101111100
010100011100010011110111110010000011011001010011111001010111011101111101
010100011100010011110111110010000011011001010011111001010111011101111110
010100011100010011110111110010000011011001010011111001010111011101111111
010100011100010011110111110010000011011001010011111001010111011110000000
010100011100010011110111110010000011011001010011111001010111011110000001
010100011100010011110111110010000011011001010011111001010111011110000010
010100011100010011110111110010000011011001010011111001010111011110000011
010100011100010011110111110010000011011001010011111001010111011110000100
010100011100010011110111110010000011011001010011111001010111011110000101
010100011100010011110111110010000011011001010011111001010111011110000110
010100011100010011110111110010000011011001010011111001010111011110000111
010100011100010011110111110010000011011001010011111001010111011110001000
010100011100010011110111110010000011011001010011111001010111011110001001
010100011100010011110111110010000011011001010011111001010111011110001010
010100011100010011110111110010000011011001010011111001010111011110001011
010100011100010011110111110010000011011001010011111001010111011110001100
010100011100010011110111110010000011011001010011111001010111011110001101
010100011100010011110111110010000011011001010011111001010111011110001110
010100011100010011110111110010000011011001010011111001010111011110001111
010100011100010011110111110010000011011001010011111001010111011110010000
010100011100010011110111110010000011011001010011111001010111011110010001
010100011100010011110111110010000011011001010011111001010111011110010010
010100011100010011110111110010000011011001010011111001010111011110010011
010100011100010011110111110010000011011001010011111001010111011110010100
010100011100010011110111110010000011011001010011111001010111011110010101
010100011100010011110111110010000011011001010011111001010111011110010110
010100011100010011110111110010000011011001010011111001010111011110010111
010100011100010011110111110010000011011001010011111001010111011110011000
010100011100010011110111110010000011011001010011111001010111011110011001
010100011100010011110111110010000011011001010011111001010111011110011010
010100011100010011110111110010000011011001010011111001010111011110011011
010100011100010011110111110010000011011001010011111001010111011110011100
010100011100010011110111110010000011011001010011111001010111011110011101
010100011100010011110111110010000011011001010011111001010111011110011110
010100011100010011110111110010000011011001010011111001010111011110011111
)" +
         R"(010100011100010011110111110010000011011001010011111001010111011110100000
010100011100010011110111110010000011011001010011111001010111011110100001
010100011100010011110111110010000011011001010011111001010111011110100010
010100011100010011110111110010000011011001010011111001010111011110100011
010100011100010011110111110010000011011001010011111001010111011110100100
010100011100010011110111110010000011011001010011111001010111011110100101
010100011100010011110111110010000011011001010011111001010111011110100110
010100011100010011110111110010000011011001010011111001010111011110100111
010100011100010011110111110010000011011001010011111001010111011110101000
010100011100010011110111110010000011011001010011111001010111011110101001
010100011100010011110111110010000011011001010011111001010111011110101010
010100011100010011110111110010000011011001010011111001010111011110101011
010100011100010011110111110010000011011001010011111001010111011110101100
010100011100010011110111110010000011011001010011111001010111011110101101
010100011100010011110111110010000011011001010011111001010111011110101110
010100011100010011110111110010000011011001010011111001010111011110101111
010100011100010011110111110010000011011001010011111001010111011110110000
010100011100010011110111110010000011011001010011111001010111011110110001
010100011100010011110111110010000011011001010011111001010111011110110010
010100011100010011110111110010000011011001010011111001010111011110110011
010100011100010011110111110010000011011001010011111001010111011110110100
010100011100010011110111110010000011011001010011111001010111011110110101
010100011100010011110111110010000011011001010011111001010111011110110110
010100011100010011110111110010000011011001010011111001010111011110110111
010100011100010011110111110010000011011001010011111001010111011110111000
010100011100010011110111110010000011011001010011111001010111011110111001
010100011100010011110111110010000011011001010011111001010111011110111010
010100011100010011110111110010000011011001010011111001010111011110111011
010100011100010011110111110010000011011001010011111001010111011110111100
010100011100010011110111110010000011011001010011111001010111011110111101
010100011100010011110111110010000011011001010011111001010111011110111110
010100011100010011110111110010000011011001010011111001010111011110111111
010100011100010011110111110010000011011001010011111001010111011111000000
010100011100010011110111110010000011011001010011111001010111011111000001
010100011100010011110111110010000011011001010011111001010111011111000010
010100011100010011110111110010000011011001010011111001010111011111000011
010100011100010011110111110010000011011001010011111001010111011111000100
010100011100010011110111110010000011011001010011111001010111011111000101
010100011100010011110111110010000011011001010011111001010111011111000110
010100011100010011110111110010000011011001010011111001010111011111000111
010100011100010011110111110010000011011001010011111001010111011111001000
010100011100010011110111110010000011011001010011111001010111011111001001
010100011100010011110111110010000011011001010011111001010111011111001010
010100011100010011110111110010000011011001010011111001010111011111001011
010100011100010011110111110010000011011001010011111001010111011111001100
010100011100010011110111110010000011011001010011111001010111011111001101
010100011100010011110111110010000011011001010011111001010111011111001110
010100011100010011110111110010000011011001010011111001010111011111001111
010100011100010011110111110010000011011001010011111001010111011111010000
010100011100010011110111110010000011011001010011111001010111011111010001
010100011100010011110111110010000011011001010011111001010111011111010010
010100011100010011110111110010000011011001010011111001010111011111010011
010100011100010011110111110010000011011001010011111001010111011111010100
010100011100010011110111110010000011011001010011111001010111011111010101
010100011100010011110111110010000011011001010011111001010111011111010110
010100011100010011110111110010000011011001010011111001010111011111010111
010100011100010011110111110010000011011001010011111001010111011111011000
010100011100010011110111110010000011011001010011111001010111011111011001
010100011100010011110111110010000011011001010011111001010111011111011010
010100011100010011110111110010000011011001010011111001010111011111011011
010100011100010011110111110010000011011001010011111001010111011111011100
010100011100010011110111110010000011011001010011111001010111011111011101
010100011100010011110111110010000011011001010011111001010111011111011110
010100011100010011110111110010000011011001010011111001010111011111011111
010100011100010011110111110010000011011001010011111001010111011111100000
010100011100010011110111110010000011011001010011111001010111011111100001
010100011100010011110111110010000011011001010011111001010111011111100010
010100011100010011110111110010000011011001010011111001010111011111100011
010100011100010011110111110010000011011001010011111001010111011111100100
010100011100010011110111110010000011011001010011111001010111011111100101
010100011100010011110111110010000011011001010011111001010111011111100110
010100011100010011110111110010000011011001010011111001010111011111100111
010100011100010011110111110010000011011001010011111001010111011111101000
010100011100010011110111110010000011011001010011111001010111011111101001
010100011100010011110111110010000011011001010011111001010111011111101010
010100011100010011110111110010000011011001010011111001010111011111101011
010100011100010011110111110010000011011001010011111001010111011111101100
010100011100010011110111110010000011011001010011111001010111011111101101
010100011100010011110111110010000011011001010011111001010111011111101110
010100011100010011110111110010000011011001010011111001010111011111101111
010100011100010011110111110010000011011001010011111001010111011111110000
010100011100010011110111110010000011011001010011111001010111011111110001
010100011100010011110111110010000011011001010011111001010111011111110010
010100011100010011110111110010000011011001010011111001010111011111110011
010100011100010011110111110010000011011001010011111001010111011111110100
010100011100010011110111110010000011011001010011111001010111011111110101
010100011100010011110111110010000011011001010011111001010111011111110110
010100011100010011110111110010000011011001010011111001010111011111110111
010100011100010011110111110010000011011001010011111001010111011111111000
010100011100010011110111110010000011011001010011111001010111011111111001
010100011100010011110111110010000011011001010011111001010111011111111010
010100011100010011110111110010000011011001010011111001010111011111111011
010100011100010011110111110010000011011001010011111001010111011111111100
010100011100010011110111110010000011011001010011111001010111011111111101
010100011100010011110111110010000011011001010011111001010111011111111110
010100011100010011110111110010000011011001010011111001010111011111111111
0101000111000100111101111100100000110110010100111110010101111000
0101000111000100111101111100100000110110010100111110010101111001
0101000111000100111101111100100000110110010100111110010101111010
)" +
         R"(0101000111000100111101111100100000110110010100111110010101111011
0101000111000100111101111100100000110110010100111110010101111100
0101000111000100111101111100100000110110010100111110010101111101
0101000111000100111101111100100000110110010100111110010101111110
0101000111000100111101111100100000110110010100111110010101111111
0101000111000100111101111100100000110110010100111110010110000000
0101000111000100111101111100100000110110010100111110010110000001
0101000111000100111101111100100000110110010100111110010110000010
0101000111000100111101111100100000110110010100111110010110000011
0101000111000100111101111100100000110110010100111110010110000100
0101000111000100111101111100100000110110010100111110010110000101
0101000111000100111101111100100000110110010100111110010110000110
0101000111000100111101111100100000110110010100111110010110000111
0101000111000100111101111100100000110110010100111110010110001000
0101000111000100111101111100100000110110010100111110010110001001
0101000111000100111101111100100000110110010100111110010110001010
0101000111000100111101111100100000110110010100111110010110001011
0101000111000100111101111100100000110110010100111110010110001100
0101000111000100111101111100100000110110010100111110010110001101
0101000111000100111101111100100000110110010100111110010110001110
0101000111000100111101111100100000110110010100111110010110001111
0101000111000100111101111100100000110110010100111110010110010000
0101000111000100111101111100100000110110010100111110010110010001
0101000111000100111101111100100000110110010100111110010110010010
0101000111000100111101111100100000110110010100111110010110010011
0101000111000100111101111100100000110110010100111110010110010100
0101000111000100111101111100100000110110010100111110010110010101
0101000111000100111101111100100000110110010100111110010110010110
0101000111000100111101111100100000110110010100111110010110010111
0101000111000100111101111100100000110110010100111110010110011000
0101000111000100111101111100100000110110010100111110010110011001
0101000111000100111101111100100000110110010100111110010110011010
0101000111000100111101111100100000110110010100111110010110011011
0101000111000100111101111100100000110110010100111110010110011100
0101000111000100111101111100100000110110010100111110010110011101
0101000111000100111101111100100000110110010100111110010110011110
0101000111000100111101111100100000110110010100111110010110011111
0101000111000100111101111100100000110110010100111110010110100000
0101000111000100111101111100100000110110010100111110010110100001
0101000111000100111101111100100000110110010100111110010110100010
0101000111000100111101111100100000110110010100111110010110100011
0101000111000100111101111100100000110110010100111110010110100100
0101000111000100111101111100100000110110010100111110010110100101
0101000111000100111101111100100000110110010100111110010110100110
0101000111000100111101111100100000110110010100111110010110100111
0101000111000100111101111100100000110110010100111110010110101000
0101000111000100111101111100100000110110010100111110010110101001
0101000111000100111101111100100000110110010100111110010110101010
0101000111000100111101111100100000110110010100111110010110101011
0101000111000100111101111100100000110110010100111110010110101100
0101000111000100111101111100100000110110010100111110010110101101
0101000111000100111101111100100000110110010100111110010110101110
0101000111000100111101111100100000110110010100111110010110101111
0101000111000100111101111100100000110110010100111110010110110000
0101000111000100111101111100100000110110010100111110010110110001
0101000111000100111101111100100000110110010100111110010110110010
0101000111000100111101111100100000110110010100111110010110110011
0101000111000100111101111100100000110110010100111110010110110100
0101000111000100111101111100100000110110010100111110010110110101
0101000111000100111101111100100000110110010100111110010110110110
0101000111000100111101111100100000110110010100111110010110110111
0101000111000100111101111100100000110110010100111110010110111000
0101000111000100111101111100100000110110010100111110010110111001
0101000111000100111101111100100000110110010100111110010110111010
0101000111000100111101111100100000110110010100111110010110111011
0101000111000100111101111100100000110110010100111110010110111100
0101000111000100111101111100100000110110010100111110010110111101
0101000111000100111101111100100000110110010100111110010110111110
0101000111000100111101111100100000110110010100111110010110111111
0101000111000100111101111100100000110110010100111110010111000000
0101000111000100111101111100100000110110010100111110010111000001
0101000111000100111101111100100000110110010100111110010111000010
0101000111000100111101111100100000110110010100111110010111000011
0101000111000100111101111100100000110110010100111110010111000100
0101000111000100111101111100100000110110010100111110010111000101
0101000111000100111101111100100000110110010100111110010111000110
0101000111000100111101111100100000110110010100111110010111000111
0101000111000100111101111100100000110110010100111110010111001000
0101000111000100111101111100100000110110010100111110010111001001
0101000111000100111101111100100000110110010100111110010111001010
0101000111000100111101111100100000110110010100111110010111001011
0101000111000100111101111100100000110110010100111110010111001100
0101000111000100111101111100100000110110010100111110010111001101
0101000111000100111101111100100000110110010100111110010111001110
0101000111000100111101111100100000110110010100111110010111001111
0101000111000100111101111100100000110110010100111110010111010000
0101000111000100111101111100100000110110010100111110010111010001
0101000111000100111101111100100000110110010100111110010111010010
0101000111000100111101111100100000110110010100111110010111010011
0101000111000100111101111100100000110110010100111110010111010100
0101000111000100111101111100100000110110010100111110010111010101
0101000111000100111101111100100000110110010100111110010111010110
0101000111000100111101111100100000110110010100111110010111010111
0101000111000100111101111100100000110110010100111110010111011000
0101000111000100111101111100100000110110010100111110010111011001
0101000111000100111101111100100000110110010100111110010111011010
0101000111000100111101111100100000110110010100111110010111011011
0101000111000100111101111100100000110110010100111110010111011100
0101000111000100111101111100100000110110010100111110010111011101
)" +
         R"(0101000111000100111101111100100000110110010100111110010111011110
0101000111000100111101111100100000110110010100111110010111011111
0101000111000100111101111100100000110110010100111110010111100000
0101000111000100111101111100100000110110010100111110010111100001
0101000111000100111101111100100000110110010100111110010111100010
0101000111000100111101111100100000110110010100111110010111100011
0101000111000100111101111100100000110110010100111110010111100100
0101000111000100111101111100100000110110010100111110010111100101
0101000111000100111101111100100000110110010100111110010111100110
0101000111000100111101111100100000110110010100111110010111100111
0101000111000100111101111100100000110110010100111110010111101000
0101000111000100111101111100100000110110010100111110010111101001
0101000111000100111101111100100000110110010100111110010111101010
0101000111000100111101111100100000110110010100111110010111101011
0101000111000100111101111100100000110110010100111110010111101100
0101000111000100111101111100100000110110010100111110010111101101
0101000111000100111101111100100000110110010100111110010111101110
0101000111000100111101111100100000110110010100111110010111101111
0101000111000100111101111100100000110110010100111110010111110000
0101000111000100111101111100100000110110010100111110010111110001
0101000111000100111101111100100000110110010100111110010111110010
0101000111000100111101111100100000110110010100111110010111110011
0101000111000100111101111100100000110110010100111110010111110100
0101000111000100111101111100100000110110010100111110010111110101
0101000111000100111101111100100000110110010100111110010111110110
0101000111000100111101111100100000110110010100111110010111110111
0101000111000100111101111100100000110110010100111110010111111000
0101000111000100111101111100100000110110010100111110010111111001
0101000111000100111101111100100000110110010100111110010111111010
0101000111000100111101111100100000110110010100111110010111111011
0101000111000100111101111100100000110110010100111110010111111100
0101000111000100111101111100100000110110010100111110010111111101
0101000111000100111101111100100000110110010100111110010111111110
0101000111000100111101111100100000110110010100111110010111111111
01010001110001001111011111001000001101100101001111100110
01010001110001001111011111001000001101100101001111100111
01010001110001001111011111001000001101100101001111101000
01010001110001001111011111001000001101100101001111101001
01010001110001001111011111001000001101100101001111101010
01010001110001001111011111001000001101100101001111101011
01010001110001001111011111001000001101100101001111101100
01010001110001001111011111001000001101100101001111101101
01010001110001001111011111001000001101100101001111101110
01010001110001001111011111001000001101100101001111101111
01010001110001001111011111001000001101100101001111110000
01010001110001001111011111001000001101100101001111110001
01010001110001001111011111001000001101100101001111110010
01010001110001001111011111001000001101100101001111110011
01010001110001001111011111001000001101100101001111110100
01010001110001001111011111001000001101100101001111110101
01010001110001001111011111001000001101100101001111110110
01010001110001001111011111001000001101100101001111110111
01010001110001001111011111001000001101100101001111111000
01010001110001001111011111001000001101100101001111111001
01010001110001001111011111001000001101100101001111111010
01010001110001001111011111001000001101100101001111111011
01010001110001001111011111001000001101100101001111111100
01010001110001001111011111001000001101100101001111111101
01010001110001001111011111001000001101100101001111111110
01010001110001001111011111001000001101100101001111111111
010100011100010011110111110010000011011001010100
010100011100010011110111110010000011011001010101
010100011100010011110111110010000011011001010110
010100011100010011110111110010000011011001010111
010100011100010011110111110010000011011001011000
010100011100010011110111110010000011011001011001
010100011100010011110111110010000011011001011010
010100011100010011110111110010000011011001011011
010100011100010011110111110010000011011001011100
010100011100010011110111110010000011011001011101
010100011100010011110111110010000011011001011110
010100011100010011110111110010000011011001011111
010100011100010011110111110010000011011001100000
010100011100010011110111110010000011011001100001
010100011100010011110111110010000011011001100010
010100011100010011110111110010000011011001100011
010100011100010011110111110010000011011001100100
010100011100010011110111110010000011011001100101
010100011100010011110111110010000011011001100110
010100011100010011110111110010000011011001100111
010100011100010011110111110010000011011001101000
010100011100010011110111110010000011011001101001
010100011100010011110111110010000011011001101010
010100011100010011110111110010000011011001101011
010100011100010011110111110010000011011001101100
010100011100010011110111110010000011011001101101
010100011100010011110111110010000011011001101110
010100011100010011110111110010000011011001101111
010100011100010011110111110010000011011001110000
010100011100010011110111110010000011011001110001
010100011100010011110111110010000011011001110010
010100011100010011110111110010000011011001110011
010100011100010011110111110010000011011001110100
010100011100010011110111110010000011011001110101
010100011100010011110111110010000011011001110110
010100011100010011110111110010000011011001110111
010100011100010011110111110010000011011001111000
010100011100010011110111110010000011011001111001
010100011100010011110111110010000011011001111010
)" +
         R"(010100011100010011110111110010000011011001111011
010100011100010011110111110010000011011001111100
010100011100010011110111110010000011011001111101
010100011100010011110111110010000011011001111110
010100011100010011110111110010000011011001111111
010100011100010011110111110010000011011010000000
010100011100010011110111110010000011011010000001
010100011100010011110111110010000011011010000010
010100011100010011110111110010000011011010000011
010100011100010011110111110010000011011010000100
010100011100010011110111110010000011011010000101
010100011100010011110111110010000011011010000110
010100011100010011110111110010000011011010000111
010100011100010011110111110010000011011010001000
010100011100010011110111110010000011011010001001
010100011100010011110111110010000011011010001010
010100011100010011110111110010000011011010001011
010100011100010011110111110010000011011010001100
010100011100010011110111110010000011011010001101
010100011100010011110111110010000011011010001110
010100011100010011110111110010000011011010001111
010100011100010011110111110010000011011010010000
010100011100010011110111110010000011011010010001
010100011100010011110111110010000011011010010010
010100011100010011110111110010000011011010010011
010100011100010011110111110010000011011010010100
010100011100010011110111110010000011011010010101
010100011100010011110111110010000011011010010110
010100011100010011110111110010000011011010010111
010100011100010011110111110010000011011010011000
010100011100010011110111110010000011011010011001
010100011100010011110111110010000011011010011010
010100011100010011110111110010000011011010011011
010100011100010011110111110010000011011010011100
010100011100010011110111110010000011011010011101
010100011100010011110111110010000011011010011110
010100011100010011110111110010000011011010011111
010100011100010011110111110010000011011010100000
010100011100010011110111110010000011011010100001
010100011100010011110111110010000011011010100010
010100011100010011110111110010000011011010100011
010100011100010011110111110010000011011010100100
010100011100010011110111110010000011011010100101
010100011100010011110111110010000011011010100110
010100011100010011110111110010000011011010100111
010100011100010011110111110010000011011010101000
010100011100010011110111110010000011011010101001
010100011100010011110111110010000011011010101010
010100011100010011110111110010000011011010101011
010100011100010011110111110010000011011010101100
010100011100010011110111110010000011011010101101
010100011100010011110111110010000011011010101110
010100011100010011110111110010000011011010101111
010100011100010011110111110010000011011010110000
010100011100010011110111110010000011011010110001
010100011100010011110111110010000011011010110010
010100011100010011110111110010000011011010110011
010100011100010011110111110010000011011010110100
010100011100010011110111110010000011011010110101
010100011100010011110111110010000011011010110110
010100011100010011110111110010000011011010110111
010100011100010011110111110010000011011010111000
010100011100010011110111110010000011011010111001
010100011100010011110111110010000011011010111010
010100011100010011110111110010000011011010111011
010100011100010011110111110010000011011010111100
010100011100010011110111110010000011011010111101
010100011100010011110111110010000011011010111110
010100011100010011110111110010000011011010111111
010100011100010011110111110010000011011011000000
010100011100010011110111110010000011011011000001
010100011100010011110111110010000011011011000010
010100011100010011110111110010000011011011000011
010100011100010011110111110010000011011011000100
010100011100010011110111110010000011011011000101
010100011100010011110111110010000011011011000110
010100011100010011110111110010000011011011000111
010100011100010011110111110010000011011011001000
010100011100010011110111110010000011011011001001
010100011100010011110111110010000011011011001010
010100011100010011110111110010000011011011001011
010100011100010011110111110010000011011011001100
010100011100010011110111110010000011011011001101
010100011100010011110111110010000011011011001110
010100011100010011110111110010000011011011001111
010100011100010011110111110010000011011011010000
010100011100010011110111110010000011011011010001
010100011100010011110111110010000011011011010010
010100011100010011110111110010000011011011010011
010100011100010011110111110010000011011011010100
010100011100010011110111110010000011011011010101
010100011100010011110111110010000011011011010110
010100011100010011110111110010000011011011010111
010100011100010011110111110010000011011011011000
010100011100010011110111110010000011011011011001
010100011100010011110111110010000011011011011010
010100011100010011110111110010000011011011011011
010100011100010011110111110010000011011011011100
010100011100010011110111110010000011011011011101
)" +
         R"(010100011100010011110111110010000011011011011110
010100011100010011110111110010000011011011011111
010100011100010011110111110010000011011011100000
010100011100010011110111110010000011011011100001
010100011100010011110111110010000011011011100010
010100011100010011110111110010000011011011100011
010100011100010011110111110010000011011011100100
010100011100010011110111110010000011011011100101
010100011100010011110111110010000011011011100110
010100011100010011110111110010000011011011100111
010100011100010011110111110010000011011011101000
010100011100010011110111110010000011011011101001
010100011100010011110111110010000011011011101010
010100011100010011110111110010000011011011101011
010100011100010011110111110010000011011011101100
010100011100010011110111110010000011011011101101
010100011100010011110111110010000011011011101110
010100011100010011110111110010000011011011101111
010100011100010011110111110010000011011011110000
010100011100010011110111110010000011011011110001
010100011100010011110111110010000011011011110010
010100011100010011110111110010000011011011110011
010100011100010011110111110010000011011011110100
010100011100010011110111110010000011011011110101
010100011100010011110111110010000011011011110110
010100011100010011110111110010000011011011110111
010100011100010011110111110010000011011011111000
010100011100010011110111110010000011011011111001
010100011100010011110111110010000011011011111010
010100011100010011110111110010000011011011111011
010100011100010011110111110010000011011011111100
010100011100010011110111110010000011011011111101
010100011100010011110111110010000011011011111110
010100011100010011110111110010000011011011111111
0101000111000100111101111100100000110111
0101000111000100111101111100100000111000
0101000111000100111101111100100000111001
0101000111000100111101111100100000111010
0101000111000100111101111100100000111011
0101000111000100111101111100100000111100
0101000111000100111101111100100000111101
0101000111000100111101111100100000111110
0101000111000100111101111100100000111111
0101000111000100111101111100100001000000
0101000111000100111101111100100001000001
0101000111000100111101111100100001000010
0101000111000100111101111100100001000011
0101000111000100111101111100100001000100
0101000111000100111101111100100001000101
0101000111000100111101111100100001000110
0101000111000100111101111100100001000111
0101000111000100111101111100100001001000
0101000111000100111101111100100001001001
0101000111000100111101111100100001001010
0101000111000100111101111100100001001011
0101000111000100111101111100100001001100
0101000111000100111101111100100001001101
0101000111000100111101111100100001001110
0101000111000100111101111100100001001111
0101000111000100111101111100100001010000
0101000111000100111101111100100001010001
0101000111000100111101111100100001010010
0101000111000100111101111100100001010011
0101000111000100111101111100100001010100
0101000111000100111101111100100001010101
0101000111000100111101111100100001010110
0101000111000100111101111100100001010111
0101000111000100111101111100100001011000
0101000111000100111101111100100001011001
0101000111000100111101111100100001011010
0101000111000100111101111100100001011011
0101000111000100111101111100100001011100
0101000111000100111101111100100001011101
0101000111000100111101111100100001011110
0101000111000100111101111100100001011111
0101000111000100111101111100100001100000
0101000111000100111101111100100001100001
0101000111000100111101111100100001100010
0101000111000100111101111100100001100011
0101000111000100111101111100100001100100
0101000111000100111101111100100001100101
0101000111000100111101111100100001100110
0101000111000100111101111100100001100111
0101000111000100111101111100100001101000
0101000111000100111101111100100001101001
0101000111000100111101111100100001101010
0101000111000100111101111100100001101011
0101000111000100111101111100100001101100
0101000111000100111101111100100001101101
0101000111000100111101111100100001101110
0101000111000100111101111100100001101111
0101000111000100111101111100100001110000
0101000111000100111101111100100001110001
0101000111000100111101111100100001110010
0101000111000100111101111100100001110011
0101000111000100111101111100100001110100
0101000111000100111101111100100001110101
0101000111000100111101111100100001110110
0101000111000100111101111100100001110111
)" +
         R"(0101000111000100111101111100100001111000
0101000111000100111101111100100001111001
0101000111000100111101111100100001111010
0101000111000100111101111100100001111011
0101000111000100111101111100100001111100
0101000111000100111101111100100001111101
0101000111000100111101111100100001111110
0101000111000100111101111100100001111111
0101000111000100111101111100100010000000
0101000111000100111101111100100010000001
0101000111000100111101111100100010000010
0101000111000100111101111100100010000011
0101000111000100111101111100100010000100
0101000111000100111101111100100010000101
0101000111000100111101111100100010000110
0101000111000100111101111100100010000111
0101000111000100111101111100100010001000
0101000111000100111101111100100010001001
0101000111000100111101111100100010001010
0101000111000100111101111100100010001011
0101000111000100111101111100100010001100
0101000111000100111101111100100010001101
0101000111000100111101111100100010001110
0101000111000100111101111100100010001111
0101000111000100111101111100100010010000
0101000111000100111101111100100010010001
0101000111000100111101111100100010010010
0101000111000100111101111100100010010011
0101000111000100111101111100100010010100
0101000111000100111101111100100010010101
0101000111000100111101111100100010010110
0101000111000100111101111100100010010111
0101000111000100111101111100100010011000
0101000111000100111101111100100010011001
0101000111000100111101111100100010011010
0101000111000100111101111100100010011011
0101000111000100111101111100100010011100
0101000111000100111101111100100010011101
0101000111000100111101111100100010011110
0101000111000100111101111100100010011111
0101000111000100111101111100100010100000
0101000111000100111101111100100010100001
0101000111000100111101111100100010100010
0101000111000100111101111100100010100011
0101000111000100111101111100100010100100
0101000111000100111101111100100010100101
0101000111000100111101111100100010100110
0101000111000100111101111100100010100111
0101000111000100111101111100100010101000
0101000111000100111101111100100010101001
0101000111000100111101111100100010101010
0101000111000100111101111100100010101011
0101000111000100111101111100100010101100
0101000111000100111101111100100010101101
0101000111000100111101111100100010101110
0101000111000100111101111100100010101111
0101000111000100111101111100100010110000
0101000111000100111101111100100010110001
0101000111000100111101111100100010110010
0101000111000100111101111100100010110011
0101000111000100111101111100100010110100
0101000111000100111101111100100010110101
0101000111000100111101111100100010110110
0101000111000100111101111100100010110111
0101000111000100111101111100100010111000
0101000111000100111101111100100010111001
0101000111000100111101111100100010111010
0101000111000100111101111100100010111011
0101000111000100111101111100100010111100
0101000111000100111101111100100010111101
0101000111000100111101111100100010111110
0101000111000100111101111100100010111111
0101000111000100111101111100100011000000
0101000111000100111101111100100011000001
0101000111000100111101111100100011000010
0101000111000100111101111100100011000011
0101000111000100111101111100100011000100
0101000111000100111101111100100011000101
0101000111000100111101111100100011000110
0101000111000100111101111100100011000111
0101000111000100111101111100100011001000
0101000111000100111101111100100011001001
0101000111000100111101111100100011001010
0101000111000100111101111100100011001011
0101000111000100111101111100100011001100
0101000111000100111101111100100011001101
0101000111000100111101111100100011001110
0101000111000100111101111100100011001111
0101000111000100111101111100100011010000
0101000111000100111101111100100011010001
0101000111000100111101111100100011010010
0101000111000100111101111100100011010011
0101000111000100111101111100100011010100
0101000111000100111101111100100011010101
0101000111000100111101111100100011010110
0101000111000100111101111100100011010111
0101000111000100111101111100100011011000
0101000111000100111101111100100011011001
0101000111000100111101111100100011011010
0101000111000100111101111100100011011011
0101000111000100111101111100100011011100
0101000111000100111101111100100011011101
0101000111000100111101111100100011011110
0101000111000100111101111100100011011111
0101000111000100111101111100100011100000
0101000111000100111101111100100011100001
0101000111000100111101111100100011100010
0101000111000100111101111100100011100011
0101000111000100111101111100100011100100
0101000111000100111101111100100011100101
0101000111000100111101111100100011100110
0101000111000100111101111100100011100111
0101000111000100111101111100100011101000
0101000111000100111101111100100011101001
0101000111000100111101111100100011101010
0101000111000100111101111100100011101011
0101000111000100111101111100100011101100
0101000111000100111101111100100011101101
0101000111000100111101111100100011101110
0101000111000100111101111100100011101111
0101000111000100111101111100100011110000
0101000111000100111101111100100011110001
0101000111000100111101111100100011110010
0101000111000100111101111100100011110011
0101000111000100111101111100100011110100
0101000111000100111101111100100011110101
0101000111000100111101111100100011110110
0101000111000100111101111100100011110111
0101000111000100111101111100100011111000
0101000111000100111101111100100011111001
0101000111000100111101111100100011111010
0101000111000100111101111100100011111011
0101000111000100111101111100100011111100
0101000111000100111101111100100011111101
0101000111000100111101111100100011111110
0101000111000100111101111100100011111111
01010001110001001111011111001001
01010001110001001111011111001010
01010001110001001111011111001011
01010001110001001111011111001100
01010001110001001111011111001101
01010001110001001111011111001110
01010001110001001111011111001111
01010001110001001111011111010000
01010001110001001111011111010001
01010001110001001111011111010010
01010001110001001111011111010011
01010001110001001111011111010100
01010001110001001111011111010101
01010001110001001111011111010110
01010001110001001111011111010111
01010001110001001111011111011000
01010001110001001111011111011001
01010001110001001111011111011010
01010001110001001111011111011011
01010001110001001111011111011100
01010001110001001111011111011101
01010001110001001111011111011110
01010001110001001111011111011111
01010001110001001111011111100000
01010001110001001111011111100001
01010001110001001111011111100010
01010001110001001111011111100011
01010001110001001111011111100100
01010001110001001111011111100101
01010001110001001111011111100110
01010001110001001111011111100111
01010001110001001111011111101000
01010001110001001111011111101001
01010001110001001111011111101010
01010001110001001111011111101011
01010001110001001111011111101100
01010001110001001111011111101101
01010001110001001111011111101110
01010001110001001111011111101111
01010001110001001111011111110000
01010001110001001111011111110001
01010001110001001111011111110010
01010001110001001111011111110011
01010001110001001111011111110100
01010001110001001111011111110101
01010001110001001111011111110110
01010001110001001111011111110111
01010001110001001111011111111000
01010001110001001111011111111001
01010001110001001111011111111010
01010001110001001111011111111011
01010001110001001111011111111100
01010001110001001111011111111101
01010001110001001111011111111110
01010001110001001111011111111111
010100011100010011111000
010100011100010011111001
010100011100010011111010
010100011100010011111011
010100011100010011111100
010100011100010011111101
010100011100010011111110
010100011100010011111111
0101000111000101
0101000111000110
0101000111000111
0101000111001000
0101000111001001
0101000111001010
0101000111001011
0101000111001100
0101000111001101
0101000111001110
0101000111001111
0101000111010000
0101000111010001
0101000111010010
0101000111010011
0101000111010100
0101000111010101
0101000111010110
0101000111010111
0101000111011000
0101000111011001
0101000111011010
0101000111011011
0101000111011100
0101000111011101
0101000111011110
0101000111011111
0101000111100000
0101000111100001
0101000111100010
0101000111100011
0101000111100100
0101000111100101
0101000111100110
0101000111100111
0101000111101000
0101000111101001
0101000111101010
0101000111101011
0101000111101100
0101000111101101
0101000111101110
0101000111101111
0101000111110000
0101000111110001
0101000111110010
0101000111110011
0101000111110100
0101000111110101
0101000111110110
0101000111110111
0101000111111000
0101000111111001
0101000111111010
0101000111111011
0101000111111100
0101000111111101
0101000111111110
0101000111111111
01010010
01010011
01010100
01010101
01010110
01010111
01011000
01011001
01011010
01011011
01011100
01011101
01011110
01011111
01100000
01100001
01100010
01100011
01100100
01100101
01100110
01100111
01101000
01101001
01101010
01101011
01101100
01101101
01101110
01101111
01110000
01110001
01110010
01110011
01110100
01110101
01110110
01110111
01111000
01111001
01111010
01111011
01111100
01111101
01111110
01111111
10000000
10000001
10000010
10000011
10000100
10000101
10000110
10000111
10001000
10001001
10001010
10001011
10001100
10001101
10001110
10001111
10010000
10010001
10010010
10010011
10010100
10010101
10010110
10010111
10011000
10011001
10011010
10011011
10011100
10011101
10011110
10011111
10100000
10100001
10100010
10100011
10100100
10100101
10100110
10100111
10101000
10101001
10101010
10101011
10101100
10101101
1010111000000000
1010111000000001
1010111000000010
1010111000000011
1010111000000100
1010111000000101
1010111000000110
1010111000000111
1010111000001000
1010111000001001
1010111000001010
1010111000001011
1010111000001100
1010111000001101
1010111000001110
1010111000001111
1010111000010000
1010111000010001
1010111000010010
1010111000010011
1010111000010100
1010111000010101
1010111000010110
1010111000010111
1010111000011000
1010111000011001
1010111000011010
1010111000011011
1010111000011100
1010111000011101
1010111000011110
1010111000011111
1010111000100000
1010111000100001
1010111000100010
1010111000100011
1010111000100100
1010111000100101
1010111000100110
1010111000100111
1010111000101000
1010111000101001
1010111000101010
1010111000101011
1010111000101100
1010111000101101
1010111000101110
1010111000101111
1010111000110000
)" +
         R"(1010111000110001
1010111000110010
1010111000110011
1010111000110100
1010111000110101
1010111000110110
1010111000110111
1010111000111000
1010111000111001
1010111000111010
1010111000111011
1010111000111100
1010111000111101
1010111000111110
1010111000111111
1010111001000000
1010111001000001
1010111001000010
1010111001000011
1010111001000100
1010111001000101
101011100100011000000000
101011100100011000000001
101011100100011000000010
101011100100011000000011
101011100100011000000100
101011100100011000000101
101011100100011000000110
101011100100011000000111
101011100100011000001000
101011100100011000001001
101011100100011000001010
101011100100011000001011
101011100100011000001100
101011100100011000001101
101011100100011000001110
101011100100011000001111
101011100100011000010000
101011100100011000010001
101011100100011000010010
101011100100011000010011
101011100100011000010100
101011100100011000010101
101011100100011000010110
101011100100011000010111
101011100100011000011000
101011100100011000011001
101011100100011000011010
101011100100011000011011
101011100100011000011100
101011100100011000011101
101011100100011000011110
101011100100011000011111
101011100100011000100000
101011100100011000100001
101011100100011000100010
101011100100011000100011
101011100100011000100100
101011100100011000100101
101011100100011000100110
101011100100011000100111
101011100100011000101000
101011100100011000101001
101011100100011000101010
101011100100011000101011
101011100100011000101100
101011100100011000101101
101011100100011000101110
101011100100011000101111
101011100100011000110000
101011100100011000110001
101011100100011000110010
101011100100011000110011
101011100100011000110100
101011100100011000110101
101011100100011000110110
101011100100011000110111
101011100100011000111000
101011100100011000111001
101011100100011000111010
101011100100011000111011
101011100100011000111100
101011100100011000111101
101011100100011000111110
101011100100011000111111
101011100100011001000000
101011100100011001000001
101011100100011001000010
101011100100011001000011
101011100100011001000100
101011100100011001000101
101011100100011001000110
101011100100011001000111
101011100100011001001000
101011100100011001001001
101011100100011001001010
101011100100011001001011
101011100100011001001100
101011100100011001001101
101011100100011001001110
101011100100011001001111
101011100100011001010000
101011100100011001010001
101011100100011001010010
101011100100011001010011
101011100100011001010100
101011100100011001010101
101011100100011001010110
101011100100011001010111
101011100100011001011000
101011100100011001011001
101011100100011001011010
101011100100011001011011
101011100100011001011100
101011100100011001011101
101011100100011001011110
101011100100011001011111
101011100100011001100000
101011100100011001100001
101011100100011001100010
101011100100011001100011
101011100100011001100100
101011100100011001100101
101011100100011001100110
101011100100011001100111
101011100100011001101000
101011100100011001101001
101011100100011001101010
101011100100011001101011
101011100100011001101100
101011100100011001101101
101011100100011001101110
101011100100011001101111
101011100100011001110000
101011100100011001110001
101011100100011001110010
101011100100011001110011
101011100100011001110100
101011100100011001110101
101011100100011001110110
101011100100011001110111
101011100100011001111000
101011100100011001111001
101011100100011001111010
101011100100011001111011
101011100100011001111100
101011100100011001111101
101011100100011001111110
101011100100011001111111
101011100100011010000000
101011100100011010000001
101011100100011010000010
101011100100011010000011
101011100100011010000100
101011100100011010000101
101011100100011010000110
101011100100011010000111
101011100100011010001000
101011100100011010001001
101011100100011010001010
101011100100011010001011
101011100100011010001100
101011100100011010001101
101011100100011010001110
101011100100011010001111
101011100100011010010000
101011100100011010010001
101011100100011010010010
101011100100011010010011
101011100100011010010100
101011100100011010010101
101011100100011010010110
101011100100011010010111
101011100100011010011000
101011100100011010011001
101011100100011010011010
101011100100011010011011
101011100100011010011100
101011100100011010011101
101011100100011010011110
101011100100011010011111
101011100100011010100000
101011100100011010100001
10101110010001101010001000000000
10101110010001101010001000000001
1010111001000110101000100000001000000000
1010111001000110101000100000001000000001
1010111001000110101000100000001000000010
1010111001000110101000100000001000000011
1010111001000110101000100000001000000100
1010111001000110101000100000001000000101
1010111001000110101000100000001000000110
1010111001000110101000100000001000000111
1010111001000110101000100000001000001000
1010111001000110101000100000001000001001
1010111001000110101000100000001000001010
1010111001000110101000100000001000001011
1010111001000110101000100000001000001100
1010111001000110101000100000001000001101
1010111001000110101000100000001000001110
1010111001000110101000100000001000001111
1010111001000110101000100000001000010000
1010111001000110101000100000001000010001
1010111001000110101000100000001000010010
1010111001000110101000100000001000010011
1010111001000110101000100000001000010100
1010111001000110101000100000001000010101
1010111001000110101000100000001000010110
1010111001000110101000100000001000010111
1010111001000110101000100000001000011000
1010111001000110101000100000001000011001
1010111001000110101000100000001000011010
1010111001000110101000100000001000011011
1010111001000110101000100000001000011100
1010111001000110101000100000001000011101
1010111001000110101000100000001000011110
1010111001000110101000100000001000011111
1010111001000110101000100000001000100000
1010111001000110101000100000001000100001
1010111001000110101000100000001000100010
1010111001000110101000100000001000100011
1010111001000110101000100000001000100100
1010111001000110101000100000001000100101
1010111001000110101000100000001000100110
1010111001000110101000100000001000100111
1010111001000110101000100000001000101000
1010111001000110101000100000001000101001
1010111001000110101000100000001000101010
1010111001000110101000100000001000101011
1010111001000110101000100000001000101100
1010111001000110101000100000001000101101
1010111001000110101000100000001000101110
1010111001000110101000100000001000101111
1010111001000110101000100000001000110000
1010111001000110101000100000001000110001
1010111001000110101000100000001000110010
1010111001000110101000100000001000110011
1010111001000110101000100000001000110100
1010111001000110101000100000001000110101
1010111001000110101000100000001000110110
1010111001000110101000100000001000110111
1010111001000110101000100000001000111000
1010111001000110101000100000001000111001
1010111001000110101000100000001000111010
1010111001000110101000100000001000111011
1010111001000110101000100000001000111100
1010111001000110101000100000001000111101
1010111001000110101000100000001000111110
1010111001000110101000100000001000111111
1010111001000110101000100000001001000000
1010111001000110101000100000001001000001
1010111001000110101000100000001001000010
1010111001000110101000100000001001000011
1010111001000110101000100000001001000100
1010111001000110101000100000001001000101
1010111001000110101000100000001001000110
1010111001000110101000100000001001000111
1010111001000110101000100000001001001000
1010111001000110101000100000001001001001
1010111001000110101000100000001001001010
1010111001000110101000100000001001001011
1010111001000110101000100000001001001100
1010111001000110101000100000001001001101
1010111001000110101000100000001001001110
1010111001000110101000100000001001001111
1010111001000110101000100000001001010000
1010111001000110101000100000001001010001
1010111001000110101000100000001001010010
1010111001000110101000100000001001010011
1010111001000110101000100000001001010100
1010111001000110101000100000001001010101
1010111001000110101000100000001001010110
1010111001000110101000100000001001010111
1010111001000110101000100000001001011000
1010111001000110101000100000001001011001
1010111001000110101000100000001001011010
1010111001000110101000100000001001011011
1010111001000110101000100000001001011100
1010111001000110101000100000001001011101
1010111001000110101000100000001001011110
1010111001000110101000100000001001011111
1010111001000110101000100000001001100000
1010111001000110101000100000001001100001
1010111001000110101000100000001001100010
1010111001000110101000100000001001100011
1010111001000110101000100000001001100100
1010111001000110101000100000001001100101
1010111001000110101000100000001001100110
1010111001000110101000100000001001100111
1010111001000110101000100000001001101000
1010111001000110101000100000001001101001
1010111001000110101000100000001001101010
1010111001000110101000100000001001101011
1010111001000110101000100000001001101100
1010111001000110101000100000001001101101
1010111001000110101000100000001001101110
1010111001000110101000100000001001101111
1010111001000110101000100000001001110000
1010111001000110101000100000001001110001
)" +
         R"(1010111001000110101000100000001001110010
1010111001000110101000100000001001110011
1010111001000110101000100000001001110100
1010111001000110101000100000001001110101
1010111001000110101000100000001001110110
1010111001000110101000100000001001110111
1010111001000110101000100000001001111000
1010111001000110101000100000001001111001
1010111001000110101000100000001001111010
1010111001000110101000100000001001111011
1010111001000110101000100000001001111100
1010111001000110101000100000001001111101
1010111001000110101000100000001001111110
1010111001000110101000100000001001111111
1010111001000110101000100000001010000000
1010111001000110101000100000001010000001
1010111001000110101000100000001010000010
1010111001000110101000100000001010000011
1010111001000110101000100000001010000100
1010111001000110101000100000001010000101
1010111001000110101000100000001010000110
1010111001000110101000100000001010000111
1010111001000110101000100000001010001000
1010111001000110101000100000001010001001
1010111001000110101000100000001010001010
1010111001000110101000100000001010001011
1010111001000110101000100000001010001100
1010111001000110101000100000001010001101
1010111001000110101000100000001010001110
1010111001000110101000100000001010001111
1010111001000110101000100000001010010000
1010111001000110101000100000001010010001
1010111001000110101000100000001010010010
1010111001000110101000100000001010010011
1010111001000110101000100000001010010100
1010111001000110101000100000001010010101
1010111001000110101000100000001010010110
1010111001000110101000100000001010010111
1010111001000110101000100000001010011000
1010111001000110101000100000001010011001
1010111001000110101000100000001010011010
1010111001000110101000100000001010011011
1010111001000110101000100000001010011100
1010111001000110101000100000001010011101
1010111001000110101000100000001010011110
1010111001000110101000100000001010011111
1010111001000110101000100000001010100000
1010111001000110101000100000001010100001
1010111001000110101000100000001010100010
1010111001000110101000100000001010100011
1010111001000110101000100000001010100100
1010111001000110101000100000001010100101
1010111001000110101000100000001010100110
1010111001000110101000100000001010100111
1010111001000110101000100000001010101000
1010111001000110101000100000001010101001
1010111001000110101000100000001010101010
1010111001000110101000100000001010101011
1010111001000110101000100000001010101100
1010111001000110101000100000001010101101
1010111001000110101000100000001010101110
1010111001000110101000100000001010101111
1010111001000110101000100000001010110000
1010111001000110101000100000001010110001
1010111001000110101000100000001010110010
1010111001000110101000100000001010110011
1010111001000110101000100000001010110100
1010111001000110101000100000001010110101
1010111001000110101000100000001010110110
1010111001000110101000100000001010110111
1010111001000110101000100000001010111000
1010111001000110101000100000001010111001
1010111001000110101000100000001010111010
1010111001000110101000100000001010111011
1010111001000110101000100000001010111100
1010111001000110101000100000001010111101
1010111001000110101000100000001010111110
1010111001000110101000100000001010111111
1010111001000110101000100000001011000000
1010111001000110101000100000001011000001
1010111001000110101000100000001011000010
1010111001000110101000100000001011000011
1010111001000110101000100000001011000100
1010111001000110101000100000001011000101
1010111001000110101000100000001011000110
1010111001000110101000100000001011000111
1010111001000110101000100000001011001000
1010111001000110101000100000001011001001
1010111001000110101000100000001011001010
1010111001000110101000100000001011001011
1010111001000110101000100000001011001100
1010111001000110101000100000001011001101
1010111001000110101000100000001011001110
1010111001000110101000100000001011001111
1010111001000110101000100000001011010000
1010111001000110101000100000001011010001
1010111001000110101000100000001011010010
1010111001000110101000100000001011010011
1010111001000110101000100000001011010100
1010111001000110101000100000001011010101
1010111001000110101000100000001011010110
1010111001000110101000100000001011010111
1010111001000110101000100000001011011000
1010111001000110101000100000001011011001
1010111001000110101000100000001011011010
1010111001000110101000100000001011011011
1010111001000110101000100000001011011100
1010111001000110101000100000001011011101
1010111001000110101000100000001011011110
1010111001000110101000100000001011011111
1010111001000110101000100000001011100000
1010111001000110101000100000001011100001
1010111001000110101000100000001011100010
1010111001000110101000100000001011100011
1010111001000110101000100000001011100100
1010111001000110101000100000001011100101
1010111001000110101000100000001011100110
1010111001000110101000100000001011100111
1010111001000110101000100000001011101000
1010111001000110101000100000001011101001
1010111001000110101000100000001011101010
101011100100011010100010000000101110101100000000
101011100100011010100010000000101110101100000001
101011100100011010100010000000101110101100000010
101011100100011010100010000000101110101100000011
101011100100011010100010000000101110101100000100
101011100100011010100010000000101110101100000101
101011100100011010100010000000101110101100000110
101011100100011010100010000000101110101100000111
101011100100011010100010000000101110101100001000
101011100100011010100010000000101110101100001001
101011100100011010100010000000101110101100001010
101011100100011010100010000000101110101100001011
101011100100011010100010000000101110101100001100
101011100100011010100010000000101110101100001101
101011100100011010100010000000101110101100001110
101011100100011010100010000000101110101100001111
101011100100011010100010000000101110101100010000
101011100100011010100010000000101110101100010001
101011100100011010100010000000101110101100010010
101011100100011010100010000000101110101100010011
101011100100011010100010000000101110101100010100
101011100100011010100010000000101110101100010101
101011100100011010100010000000101110101100010110
101011100100011010100010000000101110101100010111
101011100100011010100010000000101110101100011000
101011100100011010100010000000101110101100011001
101011100100011010100010000000101110101100011010
101011100100011010100010000000101110101100011011
101011100100011010100010000000101110101100011100
101011100100011010100010000000101110101100011101
101011100100011010100010000000101110101100011110
101011100100011010100010000000101110101100011111
101011100100011010100010000000101110101100100000
101011100100011010100010000000101110101100100001
101011100100011010100010000000101110101100100010
101011100100011010100010000000101110101100100011
101011100100011010100010000000101110101100100100
101011100100011010100010000000101110101100100101
101011100100011010100010000000101110101100100110
101011100100011010100010000000101110101100100111
101011100100011010100010000000101110101100101000
101011100100011010100010000000101110101100101001
101011100100011010100010000000101110101100101010
101011100100011010100010000000101110101100101011
101011100100011010100010000000101110101100101100
101011100100011010100010000000101110101100101101
101011100100011010100010000000101110101100101110
101011100100011010100010000000101110101100101111
101011100100011010100010000000101110101100110000
101011100100011010100010000000101110101100110001
101011100100011010100010000000101110101100110010
101011100100011010100010000000101110101100110011
101011100100011010100010000000101110101100110100
101011100100011010100010000000101110101100110101
101011100100011010100010000000101110101100110110
101011100100011010100010000000101110101100110111
101011100100011010100010000000101110101100111000
101011100100011010100010000000101110101100111001
101011100100011010100010000000101110101100111010
101011100100011010100010000000101110101100111011
101011100100011010100010000000101110101100111100
101011100100011010100010000000101110101100111101
101011100100011010100010000000101110101100111110
101011100100011010100010000000101110101100111111
101011100100011010100010000000101110101101000000
101011100100011010100010000000101110101101000001
101011100100011010100010000000101110101101000010
101011100100011010100010000000101110101101000011
101011100100011010100010000000101110101101000100
101011100100011010100010000000101110101101000101
101011100100011010100010000000101110101101000110
101011100100011010100010000000101110101101000111
101011100100011010100010000000101110101101001000
101011100100011010100010000000101110101101001001
101011100100011010100010000000101110101101001010
101011100100011010100010000000101110101101001011
101011100100011010100010000000101110101101001100
101011100100011010100010000000101110101101001101
)" +
         R"(101011100100011010100010000000101110101101001110
101011100100011010100010000000101110101101001111
101011100100011010100010000000101110101101010000
101011100100011010100010000000101110101101010001
101011100100011010100010000000101110101101010010
101011100100011010100010000000101110101101010011
101011100100011010100010000000101110101101010100
101011100100011010100010000000101110101101010101
101011100100011010100010000000101110101101010110
101011100100011010100010000000101110101101010111
101011100100011010100010000000101110101101011000
101011100100011010100010000000101110101101011001
101011100100011010100010000000101110101101011010
101011100100011010100010000000101110101101011011
101011100100011010100010000000101110101101011100
101011100100011010100010000000101110101101011101
101011100100011010100010000000101110101101011110
101011100100011010100010000000101110101101011111
101011100100011010100010000000101110101101100000
101011100100011010100010000000101110101101100001
101011100100011010100010000000101110101101100010
101011100100011010100010000000101110101101100011
101011100100011010100010000000101110101101100100
101011100100011010100010000000101110101101100101
101011100100011010100010000000101110101101100110
101011100100011010100010000000101110101101100111
101011100100011010100010000000101110101101101000
101011100100011010100010000000101110101101101001
101011100100011010100010000000101110101101101010
101011100100011010100010000000101110101101101011
101011100100011010100010000000101110101101101100
101011100100011010100010000000101110101101101101
101011100100011010100010000000101110101101101110
101011100100011010100010000000101110101101101111
101011100100011010100010000000101110101101110000
101011100100011010100010000000101110101101110001
101011100100011010100010000000101110101101110010
101011100100011010100010000000101110101101110011
101011100100011010100010000000101110101101110100
101011100100011010100010000000101110101101110101
101011100100011010100010000000101110101101110110
101011100100011010100010000000101110101101110111
10101110010001101010001000000010111010110111100000000000
10101110010001101010001000000010111010110111100000000001
10101110010001101010001000000010111010110111100000000010
10101110010001101010001000000010111010110111100000000011
10101110010001101010001000000010111010110111100000000100
10101110010001101010001000000010111010110111100000000101
10101110010001101010001000000010111010110111100000000110
10101110010001101010001000000010111010110111100000000111
10101110010001101010001000000010111010110111100000001000
10101110010001101010001000000010111010110111100000001001
10101110010001101010001000000010111010110111100000001010
10101110010001101010001000000010111010110111100000001011
10101110010001101010001000000010111010110111100000001100
10101110010001101010001000000010111010110111100000001101
10101110010001101010001000000010111010110111100000001110
10101110010001101010001000000010111010110111100000001111
10101110010001101010001000000010111010110111100000010000
10101110010001101010001000000010111010110111100000010001
10101110010001101010001000000010111010110111100000010010
10101110010001101010001000000010111010110111100000010011
10101110010001101010001000000010111010110111100000010100
10101110010001101010001000000010111010110111100000010101
10101110010001101010001000000010111010110111100000010110
10101110010001101010001000000010111010110111100000010111
10101110010001101010001000000010111010110111100000011000
10101110010001101010001000000010111010110111100000011001
10101110010001101010001000000010111010110111100000011010
10101110010001101010001000000010111010110111100000011011
10101110010001101010001000000010111010110111100000011100
10101110010001101010001000000010111010110111100000011101
10101110010001101010001000000010111010110111100000011110
10101110010001101010001000000010111010110111100000011111
10101110010001101010001000000010111010110111100000100000
10101110010001101010001000000010111010110111100000100001
10101110010001101010001000000010111010110111100000100010
10101110010001101010001000000010111010110111100000100011
10101110010001101010001000000010111010110111100000100100
10101110010001101010001000000010111010110111100000100101
10101110010001101010001000000010111010110111100000100110
10101110010001101010001000000010111010110111100000100111
10101110010001101010001000000010111010110111100000101000
10101110010001101010001000000010111010110111100000101001
10101110010001101010001000000010111010110111100000101010
10101110010001101010001000000010111010110111100000101011
10101110010001101010001000000010111010110111100000101100
10101110010001101010001000000010111010110111100000101101
10101110010001101010001000000010111010110111100000101110
10101110010001101010001000000010111010110111100000101111
10101110010001101010001000000010111010110111100000110000
10101110010001101010001000000010111010110111100000110001
10101110010001101010001000000010111010110111100000110010
10101110010001101010001000000010111010110111100000110011
10101110010001101010001000000010111010110111100000110100
10101110010001101010001000000010111010110111100000110101
10101110010001101010001000000010111010110111100000110110
10101110010001101010001000000010111010110111100000110111
1010111001000110101000100000001011101011011110000011100000000000
)" +
         R"(1010111001000110101000100000001011101011011110000011100000000001
1010111001000110101000100000001011101011011110000011100000000010
1010111001000110101000100000001011101011011110000011100000000011
1010111001000110101000100000001011101011011110000011100000000100
1010111001000110101000100000001011101011011110000011100000000101
1010111001000110101000100000001011101011011110000011100000000110
1010111001000110101000100000001011101011011110000011100000000111
1010111001000110101000100000001011101011011110000011100000001000
1010111001000110101000100000001011101011011110000011100000001001
1010111001000110101000100000001011101011011110000011100000001010
1010111001000110101000100000001011101011011110000011100000001011
1010111001000110101000100000001011101011011110000011100000001100
1010111001000110101000100000001011101011011110000011100000001101
1010111001000110101000100000001011101011011110000011100000001110
1010111001000110101000100000001011101011011110000011100000001111
1010111001000110101000100000001011101011011110000011100000010000
1010111001000110101000100000001011101011011110000011100000010001
1010111001000110101000100000001011101011011110000011100000010010
1010111001000110101000100000001011101011011110000011100000010011
1010111001000110101000100000001011101011011110000011100000010100
1010111001000110101000100000001011101011011110000011100000010101
1010111001000110101000100000001011101011011110000011100000010110
1010111001000110101000100000001011101011011110000011100000010111
1010111001000110101000100000001011101011011110000011100000011000
1010111001000110101000100000001011101011011110000011100000011001
1010111001000110101000100000001011101011011110000011100000011010
1010111001000110101000100000001011101011011110000011100000011011
1010111001000110101000100000001011101011011110000011100000011100
1010111001000110101000100000001011101011011110000011100000011101
1010111001000110101000100000001011101011011110000011100000011110
1010111001000110101000100000001011101011011110000011100000011111
1010111001000110101000100000001011101011011110000011100000100000
1010111001000110101000100000001011101011011110000011100000100001
1010111001000110101000100000001011101011011110000011100000100010
1010111001000110101000100000001011101011011110000011100000100011
1010111001000110101000100000001011101011011110000011100000100100
1010111001000110101000100000001011101011011110000011100000100101
1010111001000110101000100000001011101011011110000011100000100110
1010111001000110101000100000001011101011011110000011100000100111
1010111001000110101000100000001011101011011110000011100000101000
1010111001000110101000100000001011101011011110000011100000101001
1010111001000110101000100000001011101011011110000011100000101010
1010111001000110101000100000001011101011011110000011100000101011
1010111001000110101000100000001011101011011110000011100000101100
1010111001000110101000100000001011101011011110000011100000101101
1010111001000110101000100000001011101011011110000011100000101110
1010111001000110101000100000001011101011011110000011100000101111
1010111001000110101000100000001011101011011110000011100000110000
1010111001000110101000100000001011101011011110000011100000110001
1010111001000110101000100000001011101011011110000011100000110010
1010111001000110101000100000001011101011011110000011100000110011
1010111001000110101000100000001011101011011110000011100000110100
1010111001000110101000100000001011101011011110000011100000110101
1010111001000110101000100000001011101011011110000011100000110110
1010111001000110101000100000001011101011011110000011100000110111
1010111001000110101000100000001011101011011110000011100000111000
1010111001000110101000100000001011101011011110000011100000111001
1010111001000110101000100000001011101011011110000011100000111010
1010111001000110101000100000001011101011011110000011100000111011
1010111001000110101000100000001011101011011110000011100000111100
1010111001000110101000100000001011101011011110000011100000111101
1010111001000110101000100000001011101011011110000011100000111110
1010111001000110101000100000001011101011011110000011100000111111
1010111001000110101000100000001011101011011110000011100001000000
1010111001000110101000100000001011101011011110000011100001000001
1010111001000110101000100000001011101011011110000011100001000010
1010111001000110101000100000001011101011011110000011100001000011
1010111001000110101000100000001011101011011110000011100001000100
1010111001000110101000100000001011101011011110000011100001000101
1010111001000110101000100000001011101011011110000011100001000110
1010111001000110101000100000001011101011011110000011100001000111
1010111001000110101000100000001011101011011110000011100001001000
1010111001000110101000100000001011101011011110000011100001001001
1010111001000110101000100000001011101011011110000011100001001010
1010111001000110101000100000001011101011011110000011100001001011
1010111001000110101000100000001011101011011110000011100001001100
1010111001000110101000100000001011101011011110000011100001001101
1010111001000110101000100000001011101011011110000011100001001110
1010111001000110101000100000001011101011011110000011100001001111
1010111001000110101000100000001011101011011110000011100001010000
1010111001000110101000100000001011101011011110000011100001010001
1010111001000110101000100000001011101011011110000011100001010010
1010111001000110101000100000001011101011011110000011100001010011
1010111001000110101000100000001011101011011110000011100001010100
1010111001000110101000100000001011101011011110000011100001010101
1010111001000110101000100000001011101011011110000011100001010110
1010111001000110101000100000001011101011011110000011100001010111
1010111001000110101000100000001011101011011110000011100001011000
1010111001000110101000100000001011101011011110000011100001011001
1010111001000110101000100000001011101011011110000011100001011010
1010111001000110101000100000001011101011011110000011100001011011
1010111001000110101000100000001011101011011110000011100001011100
1010111001000110101000100000001011101011011110000011100001011101
1010111001000110101000100000001011101011011110000011100001011110
1010111001000110101000100000001011101011011110000011100001011111
1010111001000110101000100000001011101011011110000011100001100000
1010111001000110101000100000001011101011011110000011100001100001
1010111001000110101000100000001011101011011110000011100001100010
1010111001000110101000100000001011101011011110000011100001100011
)" +
         R"(1010111001000110101000100000001011101011011110000011100001100100
1010111001000110101000100000001011101011011110000011100001100101
1010111001000110101000100000001011101011011110000011100001100110
1010111001000110101000100000001011101011011110000011100001100111
1010111001000110101000100000001011101011011110000011100001101000
1010111001000110101000100000001011101011011110000011100001101001
1010111001000110101000100000001011101011011110000011100001101010
1010111001000110101000100000001011101011011110000011100001101011
1010111001000110101000100000001011101011011110000011100001101100
1010111001000110101000100000001011101011011110000011100001101101
1010111001000110101000100000001011101011011110000011100001101110
1010111001000110101000100000001011101011011110000011100001101111
1010111001000110101000100000001011101011011110000011100001110000
1010111001000110101000100000001011101011011110000011100001110001
1010111001000110101000100000001011101011011110000011100001110010
1010111001000110101000100000001011101011011110000011100001110011
1010111001000110101000100000001011101011011110000011100001110100
1010111001000110101000100000001011101011011110000011100001110101
1010111001000110101000100000001011101011011110000011100001110110
1010111001000110101000100000001011101011011110000011100001110111
1010111001000110101000100000001011101011011110000011100001111000
1010111001000110101000100000001011101011011110000011100001111001
1010111001000110101000100000001011101011011110000011100001111010
1010111001000110101000100000001011101011011110000011100001111011
1010111001000110101000100000001011101011011110000011100001111100
1010111001000110101000100000001011101011011110000011100001111101
1010111001000110101000100000001011101011011110000011100001111110
1010111001000110101000100000001011101011011110000011100001111111
1010111001000110101000100000001011101011011110000011100010000000
1010111001000110101000100000001011101011011110000011100010000001
1010111001000110101000100000001011101011011110000011100010000010
1010111001000110101000100000001011101011011110000011100010000011
1010111001000110101000100000001011101011011110000011100010000100
101011100100011010100010000000101110101101111000001110001000010100000000
101011100100011010100010000000101110101101111000001110001000010100000001
101011100100011010100010000000101110101101111000001110001000010100000010
101011100100011010100010000000101110101101111000001110001000010100000011
101011100100011010100010000000101110101101111000001110001000010100000100
101011100100011010100010000000101110101101111000001110001000010100000101
101011100100011010100010000000101110101101111000001110001000010100000110
101011100100011010100010000000101110101101111000001110001000010100000111
101011100100011010100010000000101110101101111000001110001000010100001000
101011100100011010100010000000101110101101111000001110001000010100001001
101011100100011010100010000000101110101101111000001110001000010100001010
101011100100011010100010000000101110101101111000001110001000010100001011
101011100100011010100010000000101110101101111000001110001000010100001100
10101110010001101010001000000010111010110111100000111000100001010000110100000000
10101110010001101010001000000010111010110111100000111000100001010000110100000001
10101110010001101010001000000010111010110111100000111000100001010000110100000010
10101110010001101010001000000010111010110111100000111000100001010000110100000011
10101110010001101010001000000010111010110111100000111000100001010000110100000100
10101110010001101010001000000010111010110111100000111000100001010000110100000101
10101110010001101010001000000010111010110111100000111000100001010000110100000110
10101110010001101010001000000010111010110111100000111000100001010000110100000111
10101110010001101010001000000010111010110111100000111000100001010000110100001000
10101110010001101010001000000010111010110111100000111000100001010000110100001001
10101110010001101010001000000010111010110111100000111000100001010000110100001010
10101110010001101010001000000010111010110111100000111000100001010000110100001011
10101110010001101010001000000010111010110111100000111000100001010000110100001100
10101110010001101010001000000010111010110111100000111000100001010000110100001101
10101110010001101010001000000010111010110111100000111000100001010000110100001110
10101110010001101010001000000010111010110111100000111000100001010000110100001111
10101110010001101010001000000010111010110111100000111000100001010000110100010000
10101110010001101010001000000010111010110111100000111000100001010000110100010001
10101110010001101010001000000010111010110111100000111000100001010000110100010010
10101110010001101010001000000010111010110111100000111000100001010000110100010011
10101110010001101010001000000010111010110111100000111000100001010000110100010100
10101110010001101010001000000010111010110111100000111000100001010000110100010101
10101110010001101010001000000010111010110111100000111000100001010000110100010110
10101110010001101010001000000010111010110111100000111000100001010000110100010111
10101110010001101010001000000010111010110111100000111000100001010000110100011000
10101110010001101010001000000010111010110111100000111000100001010000110100011001
10101110010001101010001000000010111010110111100000111000100001010000110100011010
10101110010001101010001000000010111010110111100000111000100001010000110100011011
10101110010001101010001000000010111010110111100000111000100001010000110100011100
10101110010001101010001000000010111010110111100000111000100001010000110100011101
10101110010001101010001000000010111010110111100000111000100001010000110100011110
10101110010001101010001000000010111010110111100000111000100001010000110100011111
10101110010001101010001000000010111010110111100000111000100001010000110100100000
10101110010001101010001000000010111010110111100000111000100001010000110100100001
10101110010001101010001000000010111010110111100000111000100001010000110100100010
10101110010001101010001000000010111010110111100000111000100001010000110100100011
10101110010001101010001000000010111010110111100000111000100001010000110100100100
10101110010001101010001000000010111010110111100000111000100001010000110100100101
10101110010001101010001000000010111010110111100000111000100001010000110100100110
10101110010001101010001000000010111010110111100000111000100001010000110100100111
10101110010001101010001000000010111010110111100000111000100001010000110100101000
10101110010001101010001000000010111010110111100000111000100001010000110100101001
10101110010001101010001000000010111010110111100000111000100001010000110100101010
10101110010001101010001000000010111010110111100000111000100001010000110100101011
10101110010001101010001000000010111010110111100000111000100001010000110100101100
10101110010001101010001000000010111010110111100000111000100001010000110100101101
10101110010001101010001000000010111010110111100000111000100001010000110100101110
10101110010001101010001000000010111010110111100000111000100001010000110100101111
10101110010001101010001000000010111010110111100000111000100001010000110100110000
10101110010001101010001000000010111010110111100000111000100001010000110100110001
10101110010001101010001000000010111010110111100000111000100001010000110100110010
10101110010001101010001000000010111010110111100000111000100001010000110100110011
10101110010001101010001000000010111010110111100000111000100001010000110100110100
)" +
         R"(10101110010001101010001000000010111010110111100000111000100001010000110100110101
10101110010001101010001000000010111010110111100000111000100001010000110100110110
10101110010001101010001000000010111010110111100000111000100001010000110100110111
10101110010001101010001000000010111010110111100000111000100001010000110100111000
10101110010001101010001000000010111010110111100000111000100001010000110100111001
10101110010001101010001000000010111010110111100000111000100001010000110100111010
10101110010001101010001000000010111010110111100000111000100001010000110100111011
10101110010001101010001000000010111010110111100000111000100001010000110100111100
10101110010001101010001000000010111010110111100000111000100001010000110100111101
10101110010001101010001000000010111010110111100000111000100001010000110100111110
10101110010001101010001000000010111010110111100000111000100001010000110100111111
10101110010001101010001000000010111010110111100000111000100001010000110101000000
10101110010001101010001000000010111010110111100000111000100001010000110101000001
10101110010001101010001000000010111010110111100000111000100001010000110101000010
10101110010001101010001000000010111010110111100000111000100001010000110101000011
10101110010001101010001000000010111010110111100000111000100001010000110101000100
10101110010001101010001000000010111010110111100000111000100001010000110101000101
10101110010001101010001000000010111010110111100000111000100001010000110101000110
10101110010001101010001000000010111010110111100000111000100001010000110101000111
10101110010001101010001000000010111010110111100000111000100001010000110101001000
10101110010001101010001000000010111010110111100000111000100001010000110101001001
10101110010001101010001000000010111010110111100000111000100001010000110101001010
10101110010001101010001000000010111010110111100000111000100001010000110101001011
10101110010001101010001000000010111010110111100000111000100001010000110101001100
10101110010001101010001000000010111010110111100000111000100001010000110101001101
10101110010001101010001000000010111010110111100000111000100001010000110101001110
10101110010001101010001000000010111010110111100000111000100001010000110101001111
10101110010001101010001000000010111010110111100000111000100001010000110101010000
10101110010001101010001000000010111010110111100000111000100001010000110101010001
10101110010001101010001000000010111010110111100000111000100001010000110101010010
10101110010001101010001000000010111010110111100000111000100001010000110101010011
10101110010001101010001000000010111010110111100000111000100001010000110101010100
10101110010001101010001000000010111010110111100000111000100001010000110101010101
10101110010001101010001000000010111010110111100000111000100001010000110101010110
10101110010001101010001000000010111010110111100000111000100001010000110101010111
10101110010001101010001000000010111010110111100000111000100001010000110101011000
10101110010001101010001000000010111010110111100000111000100001010000110101011001
10101110010001101010001000000010111010110111100000111000100001010000110101011010
10101110010001101010001000000010111010110111100000111000100001010000110101011011
10101110010001101010001000000010111010110111100000111000100001010000110101011100
10101110010001101010001000000010111010110111100000111000100001010000110101011101
10101110010001101010001000000010111010110111100000111000100001010000110101011110
10101110010001101010001000000010111010110111100000111000100001010000110101011111
10101110010001101010001000000010111010110111100000111000100001010000110101100000
10101110010001101010001000000010111010110111100000111000100001010000110101100001
10101110010001101010001000000010111010110111100000111000100001010000110101100010
10101110010001101010001000000010111010110111100000111000100001010000110101100011
10101110010001101010001000000010111010110111100000111000100001010000110101100100
10101110010001101010001000000010111010110111100000111000100001010000110101100101
10101110010001101010001000000010111010110111100000111000100001010000110101100110
10101110010001101010001000000010111010110111100000111000100001010000110101100111
10101110010001101010001000000010111010110111100000111000100001010000110101101000
10101110010001101010001000000010111010110111100000111000100001010000110101101001
10101110010001101010001000000010111010110111100000111000100001010000110101101010
10101110010001101010001000000010111010110111100000111000100001010000110101101011
10101110010001101010001000000010111010110111100000111000100001010000110101101100
10101110010001101010001000000010111010110111100000111000100001010000110101101101
10101110010001101010001000000010111010110111100000111000100001010000110101101110
10101110010001101010001000000010111010110111100000111000100001010000110101101111
10101110010001101010001000000010111010110111100000111000100001010000110101110000
10101110010001101010001000000010111010110111100000111000100001010000110101110001
10101110010001101010001000000010111010110111100000111000100001010000110101110010
10101110010001101010001000000010111010110111100000111000100001010000110101110011
10101110010001101010001000000010111010110111100000111000100001010000110101110100
10101110010001101010001000000010111010110111100000111000100001010000110101110101
10101110010001101010001000000010111010110111100000111000100001010000110101110110
10101110010001101010001000000010111010110111100000111000100001010000110101110111
10101110010001101010001000000010111010110111100000111000100001010000110101111000
10101110010001101010001000000010111010110111100000111000100001010000110101111001
10101110010001101010001000000010111010110111100000111000100001010000110101111010
10101110010001101010001000000010111010110111100000111000100001010000110101111011
10101110010001101010001000000010111010110111100000111000100001010000110101111100
10101110010001101010001000000010111010110111100000111000100001010000110101111101
10101110010001101010001000000010111010110111100000111000100001010000110101111110
10101110010001101010001000000010111010110111100000111000100001010000110101111111
10101110010001101010001000000010111010110111100000111000100001010000110110000000
10101110010001101010001000000010111010110111100000111000100001010000110110000001
10101110010001101010001000000010111010110111100000111000100001010000110110000010
10101110010001101010001000000010111010110111100000111000100001010000110110000011
10101110010001101010001000000010111010110111100000111000100001010000110110000100
10101110010001101010001000000010111010110111100000111000100001010000110110000101
10101110010001101010001000000010111010110111100000111000100001010000110110000110
10101110010001101010001000000010111010110111100000111000100001010000110110000111
10101110010001101010001000000010111010110111100000111000100001010000110110001000
10101110010001101010001000000010111010110111100000111000100001010000110110001001
10101110010001101010001000000010111010110111100000111000100001010000110110001010
10101110010001101010001000000010111010110111100000111000100001010000110110001011
10101110010001101010001000000010111010110111100000111000100001010000110110001100
10101110010001101010001000000010111010110111100000111000100001010000110110001101
10101110010001101010001000000010111010110111100000111000100001010000110110001110
10101110010001101010001000000010111010110111100000111000100001010000110110001111
10101110010001101010001000000010111010110111100000111000100001010000110110010000
10101110010001101010001000000010111010110111100000111000100001010000110110010001
10101110010001101010001000000010111010110111100000111000100001010000110110010010
10101110010001101010001000000010111010110111100000111000100001010000110110010011
10101110010001101010001000000010111010110111100000111000100001010000110110010100
10101110010001101010001000000010111010110111100000111000100001010000110110010101
10101110010001101010001000000010111010110111100000111000100001010000110110010110
10101110010001101010001000000010111010110111100000111000100001010000110110010111
)" +
         R"(10101110010001101010001000000010111010110111100000111000100001010000110110011000
10101110010001101010001000000010111010110111100000111000100001010000110110011001
10101110010001101010001000000010111010110111100000111000100001010000110110011010
1010111001000110101000100000001011101011011110000011100010000101000011011001101100000000
1010111001000110101000100000001011101011011110000011100010000101000011011001101100000001
1010111001000110101000100000001011101011011110000011100010000101000011011001101100000010
1010111001000110101000100000001011101011011110000011100010000101000011011001101100000011
1010111001000110101000100000001011101011011110000011100010000101000011011001101100000100
1010111001000110101000100000001011101011011110000011100010000101000011011001101100000101
1010111001000110101000100000001011101011011110000011100010000101000011011001101100000110
1010111001000110101000100000001011101011011110000011100010000101000011011001101100000111
1010111001000110101000100000001011101011011110000011100010000101000011011001101100001000
1010111001000110101000100000001011101011011110000011100010000101000011011001101100001001
1010111001000110101000100000001011101011011110000011100010000101000011011001101100001010
1010111001000110101000100000001011101011011110000011100010000101000011011001101100001011
1010111001000110101000100000001011101011011110000011100010000101000011011001101100001100
1010111001000110101000100000001011101011011110000011100010000101000011011001101100001101
1010111001000110101000100000001011101011011110000011100010000101000011011001101100001110
1010111001000110101000100000001011101011011110000011100010000101000011011001101100001111
1010111001000110101000100000001011101011011110000011100010000101000011011001101100010000
1010111001000110101000100000001011101011011110000011100010000101000011011001101100010001
1010111001000110101000100000001011101011011110000011100010000101000011011001101100010010
1010111001000110101000100000001011101011011110000011100010000101000011011001101100010011
1010111001000110101000100000001011101011011110000011100010000101000011011001101100010100
1010111001000110101000100000001011101011011110000011100010000101000011011001101100010101
1010111001000110101000100000001011101011011110000011100010000101000011011001101100010110
1010111001000110101000100000001011101011011110000011100010000101000011011001101100010111
1010111001000110101000100000001011101011011110000011100010000101000011011001101100011000
1010111001000110101000100000001011101011011110000011100010000101000011011001101100011001
1010111001000110101000100000001011101011011110000011100010000101000011011001101100011010
1010111001000110101000100000001011101011011110000011100010000101000011011001101100011011
1010111001000110101000100000001011101011011110000011100010000101000011011001101100011100
1010111001000110101000100000001011101011011110000011100010000101000011011001101100011101
1010111001000110101000100000001011101011011110000011100010000101000011011001101100011110
1010111001000110101000100000001011101011011110000011100010000101000011011001101100011111
1010111001000110101000100000001011101011011110000011100010000101000011011001101100100000
1010111001000110101000100000001011101011011110000011100010000101000011011001101100100001
1010111001000110101000100000001011101011011110000011100010000101000011011001101100100010
1010111001000110101000100000001011101011011110000011100010000101000011011001101100100011
1010111001000110101000100000001011101011011110000011100010000101000011011001101100100100
1010111001000110101000100000001011101011011110000011100010000101000011011001101100100101
1010111001000110101000100000001011101011011110000011100010000101000011011001101100100110
1010111001000110101000100000001011101011011110000011100010000101000011011001101100100111
1010111001000110101000100000001011101011011110000011100010000101000011011001101100101000
1010111001000110101000100000001011101011011110000011100010000101000011011001101100101001
1010111001000110101000100000001011101011011110000011100010000101000011011001101100101010
1010111001000110101000100000001011101011011110000011100010000101000011011001101100101011
1010111001000110101000100000001011101011011110000011100010000101000011011001101100101100
1010111001000110101000100000001011101011011110000011100010000101000011011001101100101101
1010111001000110101000100000001011101011011110000011100010000101000011011001101100101110
1010111001000110101000100000001011101011011110000011100010000101000011011001101100101111
1010111001000110101000100000001011101011011110000011100010000101000011011001101100110000
1010111001000110101000100000001011101011011110000011100010000101000011011001101100110001
1010111001000110101000100000001011101011011110000011100010000101000011011001101100110010
1010111001000110101000100000001011101011011110000011100010000101000011011001101100110011
1010111001000110101000100000001011101011011110000011100010000101000011011001101100110100
1010111001000110101000100000001011101011011110000011100010000101000011011001101100110101
1010111001000110101000100000001011101011011110000011100010000101000011011001101100110110
1010111001000110101000100000001011101011011110000011100010000101000011011001101100110111
1010111001000110101000100000001011101011011110000011100010000101000011011001101100111000
1010111001000110101000100000001011101011011110000011100010000101000011011001101100111001
1010111001000110101000100000001011101011011110000011100010000101000011011001101100111010
1010111001000110101000100000001011101011011110000011100010000101000011011001101100111011
1010111001000110101000100000001011101011011110000011100010000101000011011001101100111100
1010111001000110101000100000001011101011011110000011100010000101000011011001101100111101
1010111001000110101000100000001011101011011110000011100010000101000011011001101100111110
1010111001000110101000100000001011101011011110000011100010000101000011011001101100111111
1010111001000110101000100000001011101011011110000011100010000101000011011001101101000000
1010111001000110101000100000001011101011011110000011100010000101000011011001101101000001
1010111001000110101000100000001011101011011110000011100010000101000011011001101101000010
1010111001000110101000100000001011101011011110000011100010000101000011011001101101000011
1010111001000110101000100000001011101011011110000011100010000101000011011001101101000100
1010111001000110101000100000001011101011011110000011100010000101000011011001101101000101
1010111001000110101000100000001011101011011110000011100010000101000011011001101101000110
1010111001000110101000100000001011101011011110000011100010000101000011011001101101000111
1010111001000110101000100000001011101011011110000011100010000101000011011001101101001000
1010111001000110101000100000001011101011011110000011100010000101000011011001101101001001
1010111001000110101000100000001011101011011110000011100010000101000011011001101101001010
1010111001000110101000100000001011101011011110000011100010000101000011011001101101001011
1010111001000110101000100000001011101011011110000011100010000101000011011001101101001100
1010111001000110101000100000001011101011011110000011100010000101000011011001101101001101
1010111001000110101000100000001011101011011110000011100010000101000011011001101101001110
1010111001000110101000100000001011101011011110000011100010000101000011011001101101001111
1010111001000110101000100000001011101011011110000011100010000101000011011001101101010000
1010111001000110101000100000001011101011011110000011100010000101000011011001101101010001
1010111001000110101000100000001011101011011110000011100010000101000011011001101101010010
1010111001000110101000100000001011101011011110000011100010000101000011011001101101010011
1010111001000110101000100000001011101011011110000011100010000101000011011001101101010100
1010111001000110101000100000001011101011011110000011100010000101000011011001101101010101
1010111001000110101000100000001011101011011110000011100010000101000011011001101101010110
1010111001000110101000100000001011101011011110000011100010000101000011011001101101010111
1010111001000110101000100000001011101011011110000011100010000101000011011001101101011000
1010111001000110101000100000001011101011011110000011100010000101000011011001101101011001
1010111001000110101000100000001011101011011110000011100010000101000011011001101101011010
1010111001000110101000100000001011101011011110000011100010000101000011011001101101011011
1010111001000110101000100000001011101011011110000011100010000101000011011001101101011100
1010111001000110101000100000001011101011011110000011100010000101000011011001101101011101
1010111001000110101000100000001011101011011110000011100010000101000011011001101101011110
1010111001000110101000100000001011101011011110000011100010000101000011011001101101011111
)" +
         R"(1010111001000110101000100000001011101011011110000011100010000101000011011001101101100000
1010111001000110101000100000001011101011011110000011100010000101000011011001101101100001
1010111001000110101000100000001011101011011110000011100010000101000011011001101101100010
1010111001000110101000100000001011101011011110000011100010000101000011011001101101100011
1010111001000110101000100000001011101011011110000011100010000101000011011001101101100100
1010111001000110101000100000001011101011011110000011100010000101000011011001101101100101
1010111001000110101000100000001011101011011110000011100010000101000011011001101101100110
1010111001000110101000100000001011101011011110000011100010000101000011011001101101100111
1010111001000110101000100000001011101011011110000011100010000101000011011001101101101000
1010111001000110101000100000001011101011011110000011100010000101000011011001101101101001
1010111001000110101000100000001011101011011110000011100010000101000011011001101101101010
1010111001000110101000100000001011101011011110000011100010000101000011011001101101101011
1010111001000110101000100000001011101011011110000011100010000101000011011001101101101100
1010111001000110101000100000001011101011011110000011100010000101000011011001101101101101
1010111001000110101000100000001011101011011110000011100010000101000011011001101101101110
1010111001000110101000100000001011101011011110000011100010000101000011011001101101101111
1010111001000110101000100000001011101011011110000011100010000101000011011001101101110000
1010111001000110101000100000001011101011011110000011100010000101000011011001101101110001
1010111001000110101000100000001011101011011110000011100010000101000011011001101101110010
1010111001000110101000100000001011101011011110000011100010000101000011011001101101110011
1010111001000110101000100000001011101011011110000011100010000101000011011001101101110100
1010111001000110101000100000001011101011011110000011100010000101000011011001101101110101
1010111001000110101000100000001011101011011110000011100010000101000011011001101101110110
1010111001000110101000100000001011101011011110000011100010000101000011011001101101110111
1010111001000110101000100000001011101011011110000011100010000101000011011001101101111000
1010111001000110101000100000001011101011011110000011100010000101000011011001101101111001
1010111001000110101000100000001011101011011110000011100010000101000011011001101101111010
1010111001000110101000100000001011101011011110000011100010000101000011011001101101111011
1010111001000110101000100000001011101011011110000011100010000101000011011001101101111100
1010111001000110101000100000001011101011011110000011100010000101000011011001101101111101
1010111001000110101000100000001011101011011110000011100010000101000011011001101101111110
1010111001000110101000100000001011101011011110000011100010000101000011011001101101111111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110000000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110000001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110000010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110000011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110000100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110000101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110000110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110000111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110001000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110001001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110001010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110001011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110001100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110001101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110001110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110001111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000000000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000000001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000000010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000000011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000000100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000000101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000000110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000000111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000001000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000001001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000001010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000001011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000001100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000001101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000001110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000001111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000010000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000010001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000010010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000010011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000010100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000010101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000010110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000010111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000011000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000011001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000011010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000011011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000011100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000011101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000011110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000011111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000100000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000100001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000100010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000100011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000100100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000100101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000100110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000100111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000101000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000101001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000101010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000101011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000101100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000101101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000101110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000101111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000110000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000110001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000110010
)" +
         R"(101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000110011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000110100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000110101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000110110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000110111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000111000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000111001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000111010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000111011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000111100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000111101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000111110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000000111111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001000000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001000001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001000010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001000011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001000100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001000101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001000110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001000111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001001000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001001001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001001010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001001011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001001100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001001101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001001110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001001111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001010000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001010001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001010010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001010011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001010100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001010101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001010110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001010111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001011000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001011001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001011010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001011011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001011100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001011101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001011110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001011111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001100000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001100001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001100010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001100011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001100100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001100101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001100110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001100111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001101000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001101001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001101010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001101011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001101100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001101101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001101110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001101111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001110000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001110001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001110010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001110011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001110100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001110101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001110110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001110111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001111000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001111001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001111010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001111011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001111100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001111101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001111110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000001111111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010000000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010000001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010000010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010000011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010000100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010000101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010000110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010000111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010001000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010001001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010001010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010001011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010001100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010001101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010001110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010001111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010010000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010010001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010010010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010010011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010010100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010010101
)" +
         R"(101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010010110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010010111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010011000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010011001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010011010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010011011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010011100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010011101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010011110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010011111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010100000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010100001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010100010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010100011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010100100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010100101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010100110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010100111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010101000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010101001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010101010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010101011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010101100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010101101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010101110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010101111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010110000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010110001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010110010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010110011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010110100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010110101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010110110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010110111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010111000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010111001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010111010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010111011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010111100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010111101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010111110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000010111111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011000000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011000001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011000010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011000011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011000100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011000101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011000110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011000111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011001000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011001001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011001010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011001011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011001100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011001101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011001110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011001111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011010000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011010001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011010010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011010011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011010100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011010101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011010110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011010111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011011000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011011001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011011010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011011011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011011100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011011101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011011110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011011111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011100000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011100001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011100010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011100011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011100100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011100101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011100110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011100111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000000000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000000001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000000010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000000011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000000100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000000101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000000110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000000111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000001000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000001001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000001010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000001011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000001100
)" +
         R"(10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000001101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000001110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000001111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100000000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100000001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100000010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100000011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100000100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100000101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100000110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100000111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100001000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100001001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100001010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100001011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100001100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100001101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100001110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100001111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100010000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100010001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100010010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100010011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100010100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100010101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100010110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100010111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100011000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100011001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100011010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100011011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100011100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100011101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100011110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100011111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100100000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100100001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100100010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100100011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100100100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100100101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100100110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100100111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100101000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100101001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100101010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100101011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100101100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100101101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100101110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100101111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100110000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100110001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100110010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100110011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100110100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100110101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100110110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100110111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100111000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100111001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100111010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100111011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100111100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100111101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100111110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000100111111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101000000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101000001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101000010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101000011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101000100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101000101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101000110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101000111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101001000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101001001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101001010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101001011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101001100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101001101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101001110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101001111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101010000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101010001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101010010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101010011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101010100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101010101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101010110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101010111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101011000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101011001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101011010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101011011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101011100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101011101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101011110
)" +
         R"(1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101011111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101100000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101100001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101100010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101100011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101100100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101100101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101100110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101100111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101101000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101101001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101101010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101101011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101101100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101101101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101101110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101101111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101110000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101110001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101110010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101110011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101110100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101110101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101110110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101110111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101111000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101111001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101111010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101111011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101111100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101111101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101111110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000101111111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110000000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110000001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110000010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110000011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110000100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110000101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110000110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110000111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110001000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110001001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110001010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110001011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110001100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110001101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110001110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110001111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110010000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110010001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110010010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110010011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110010100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110010101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110010110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110010111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110011000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110011001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110011010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110011011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110011100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110011101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110011110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110011111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110100000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110100001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110100010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110100011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110100100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110100101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110100110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110100111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110101000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110101001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110101010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110101011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110101100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110101101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110101110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110101111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110110000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110110001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110110010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110110011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110110100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110110101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110110110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110110111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110111000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110111001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110111010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110111011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110111100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110111101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110111110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000110111111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111000000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111000001
)" +
         R"(1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111000010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111000011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111000100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111000101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111000110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111000111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111001000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111001001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111001010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111001011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111001100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111001101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111001110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111001111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111010000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111010001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111010010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111010011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111010100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111010101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111010110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111010111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111011000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111011001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111011010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111011011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111011100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111011101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111011110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111011111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111100000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111100001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111100010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111100011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111100100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111100101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111100110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111100111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111101000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111101001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111101010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111101011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111101100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111101101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111101110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111101111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111110000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111110001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111110010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111110011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111110100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111110101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111110110
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111110111
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111111000
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111111001
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111111010
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111111011
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111111100
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111111101
1010111001000110101000100000001011101011011110000011100010000101000011011001101110010000111011000001000111111110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100000000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100000001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100000010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100000011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100000100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100000101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100000110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100000111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100001000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100001001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100001010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100001011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100001100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100001101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100001110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100001111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100010000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100010001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100010010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100010011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100010100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100010101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100010110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100010111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100011000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100011001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100011010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100011011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100011100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100011101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100011110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100011111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100100000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100100001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100100010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100100011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100100100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100100101
)" +
         R"(101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100100110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100100111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100101000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100101001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100101010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100101011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100101100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100101101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100101110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100101111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100110000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100110001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100110010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100110011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100110100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100110101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100110110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100110111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100111000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100111001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100111010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100111011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100111100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100111101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100111110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111100111111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101000000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101000001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101000010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101000011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101000100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101000101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101000110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101000111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101001000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101001001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101001010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101001011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101001100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101001101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101001110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101001111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101010000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101010001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101010010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101010011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101010100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101010101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101010110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101010111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101011000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101011001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101011010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101011011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101011100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101011101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101011110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101011111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101100000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101100001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101100010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101100011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101100100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101100101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101100110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101100111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101101000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101101001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101101010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101101011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101101100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101101101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101101110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101101111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101110000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101110001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101110010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101110011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101110100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101110101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101110110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101110111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101111000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101111001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101111010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101111011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101111100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101111101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101111110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111101111111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110000000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110000001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110000010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110000011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110000100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110000101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110000110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110000111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110001000
)" +
         R"(101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110001001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110001010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110001011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110001100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110001101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110001110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110001111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110010000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110010001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110010010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110010011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110010100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110010101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110010110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110010111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110011000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110011001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110011010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110011011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110011100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110011101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110011110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110011111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110100000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110100001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110100010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110100011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110100100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110100101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110100110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110100111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110101000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110101001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110101010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110101011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110101100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110101101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110101110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110101111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110110000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110110001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110110010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110110011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110110100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110110101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110110110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110110111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110111000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110111001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110111010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110111011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110111100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110111101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110111110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111110111111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111000000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111000001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111000010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111000011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111000100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111000101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111000110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111000111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111001000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111001001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111001010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111001011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111001100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111001101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111001110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111001111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111010000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111010001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111010010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111010011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111010100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111010101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111010110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111010111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111011000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111011001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111011010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111011011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111011100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111011101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111011110
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111011111
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111100000
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111100001
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111100010
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111100011
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111100100
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111100101
101011100100011010100010000000101110101101111000001110001000010100001101100110111001000011101100000100011111111111100110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100000000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100000001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100000010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100000011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100000100
)" +
         R"(10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100000101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100000110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100000111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100001000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100001001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100001010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100001011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100001100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100001101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100001110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100001111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100010000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100010001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100010010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100010011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100010100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100010101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100010110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100010111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100011000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100011001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100011010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100011011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100011100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100011101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100011110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100011111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100100000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100100001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100100010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100100011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100100100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100100101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100100110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100100111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100101000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100101001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100101010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100101011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100101100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100101101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100101110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100101111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100110000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100110001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100110010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100110011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100110100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100110101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100110110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100110111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100111000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100111001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100111010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100111011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100111100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100111101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100111110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011100111111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101000000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101000001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101000010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101000011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101000100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101000101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101000110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101000111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101001000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101001001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101001010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101001011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101001100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101001101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101001110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101001111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101010000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101010001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101010010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101010011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101010100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101010101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101010110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101010111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101011000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101011001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101011010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101011011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101011100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101011101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101011110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101011111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101100000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101100001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101100010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101100011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101100100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101100101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101100110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101100111
)" +
         R"(10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101101000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101101001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101101010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101101011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101101100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101101101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101101110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101101111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101110000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101110001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101110010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101110011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101110100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101110101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101110110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101110111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101111000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101111001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101111010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101111011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101111100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101111101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101111110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011101111111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110000000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110000001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110000010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110000011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110000100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110000101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110000110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110000111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110001000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110001001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110001010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110001011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110001100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110001101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110001110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110001111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110010000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110010001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110010010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110010011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110010100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110010101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110010110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110010111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110011000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110011001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110011010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110011011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110011100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110011101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110011110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110011111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110100000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110100001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110100010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110100011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110100100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110100101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110100110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110100111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110101000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110101001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110101010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110101011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110101100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110101101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110101110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110101111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110110000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110110001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110110010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110110011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110110100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110110101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110110110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110110111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110111000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110111001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110111010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110111011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110111100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110111101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110111110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011110111111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111000000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111000001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111000010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111000011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111000100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111000101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111000110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111000111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111001000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111001001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111001010
)" +
         R"(10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111001011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111001100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111001101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111001110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111001111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111010000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111010001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111010010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111010011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111010100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111010101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111010110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111010111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111011000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111011001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111011010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111011011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111011100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111011101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111011110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111011111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111100000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111100001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111100010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111100011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111100100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111100101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111100110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111100111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111101000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111101001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111101010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111101011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111101100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111101101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111101110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111101111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111110000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111110001
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111110010
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111110011
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111110100
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111110101
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111110110
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111110111
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111111000
10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111111001
)"},

    {Decimal128(123456789.000000),
     Decimal128(123456789.000000),
     Decimal128(-1000000000000000L),
     Decimal128(0x7000000000000000L),
     1,
     R"(10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111111001
)"},

    {Decimal128(123456789.000000),
     Decimal128(123456789.000000),
     Decimal128(-1000000000000000L),
     Decimal128(0x7000000000000000L),
     8,
     R"(10101110010001101010001000000010111010110111100000111000100001010000110110011011100100001110110000010001111111111110011111111001
)"},
